/*
 * Decompiled with CFR 0.152.
 */
package com.java2html.secondparse;

import com.java2html.HTMLFileWriter;
import com.java2html.Position;
import com.java2html.secondparse.JavaCharStream;
import com.java2html.secondparse.JavaParser;
import com.java2html.secondparse.JavaParserConstants;
import com.java2html.secondparse.JavaParserTreeConstants;
import com.java2html.secondparse.Node;
import com.java2html.secondparse.Token;

public class SimpleNode
implements Node,
JavaParserConstants {
    protected Node parent;
    protected Node[] children;
    protected int id;
    JavaParser parser = null;
    protected Token begin;
    protected Token end;
    private static Token prevToken = null;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(JavaParser javaParser, int n) {
        this(n);
        this.parser = javaParser;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children == null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public void setFirstToken(Token token) {
        this.begin = token;
    }

    public void setLastToken(Token token) {
        this.end = token;
    }

    public void process(HTMLFileWriter hTMLFileWriter) {
        Token token = this.begin;
        int n = this.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(i);
            while (token != simpleNode.begin) {
                this.print(token, hTMLFileWriter);
                token = token.next;
            }
            simpleNode.process(hTMLFileWriter);
            token = simpleNode.end;
        }
        while (token != null) {
            this.print(token, hTMLFileWriter);
            token = token.next;
        }
    }

    protected void print(Token token, HTMLFileWriter hTMLFileWriter) {
        if (token == prevToken) {
            return;
        }
        this.printSpecial(token.specialToken, hTMLFileWriter);
        this.printToken(token, hTMLFileWriter);
    }

    protected void printSpecial(Token token, HTMLFileWriter hTMLFileWriter) {
        if (token != null) {
            while (token.specialToken != null) {
                token = token.specialToken;
            }
            while (token != null) {
                this.tokenColourizeOpen(token, hTMLFileWriter);
                hTMLFileWriter.write(this.addUnicodeEscapes(token.image, new Position(token.beginColumn, token.beginLine)));
                this.tokenColourizeClose(token, hTMLFileWriter);
                token = token.next;
            }
        }
    }

    protected void printToken(Token token, HTMLFileWriter hTMLFileWriter) {
        if (token == prevToken) {
            return;
        }
        prevToken = token;
        this.tokenColourizeOpen(token, hTMLFileWriter);
        hTMLFileWriter.write(this.addUnicodeEscapes(token.image, new Position(token.beginColumn, token.beginLine)));
        this.tokenColourizeClose(token, hTMLFileWriter);
    }

    private void tokenColourizeOpen(Token token, HTMLFileWriter hTMLFileWriter) {
        hTMLFileWriter.setHTMLMode(false);
        switch (token.kind) {
            case 75: {
                hTMLFileWriter.write("<FONT ID=\"StringLiteral\">");
                break;
            }
            case 74: {
                hTMLFileWriter.write("<FONT ID=\"CharacerLiteral\">");
                break;
            }
            case 8: {
                hTMLFileWriter.write("<FONT ID=\"SingleLineComment\">");
                break;
            }
            case 9: {
                hTMLFileWriter.write("<FONT ID=\"FormalComment\">");
                break;
            }
            case 10: {
                hTMLFileWriter.write("<FONT ID=\"MultiLineComment\">");
                break;
            }
            case 12: {
                hTMLFileWriter.write("<FONT ID=\"Abstract\">");
                break;
            }
            case 14: {
                hTMLFileWriter.write("<FONT ID=\"Boolean\">");
                break;
            }
            case 15: {
                hTMLFileWriter.write("<FONT ID=\"Break\">");
                break;
            }
            case 16: {
                hTMLFileWriter.write("<FONT ID=\"Byte\">");
                break;
            }
            case 17: {
                hTMLFileWriter.write("<FONT ID=\"Case\">");
                break;
            }
            case 18: {
                hTMLFileWriter.write("<FONT ID=\"Catch\">");
                break;
            }
            case 19: {
                hTMLFileWriter.write("<FONT ID=\"Char\">");
                break;
            }
            case 20: {
                hTMLFileWriter.write("<FONT ID=\"Class\">");
                break;
            }
            case 21: {
                hTMLFileWriter.write("<FONT ID=\"Const\">");
                break;
            }
            case 22: {
                hTMLFileWriter.write("<FONT ID=\"Continue\">");
                break;
            }
            case 23: {
                hTMLFileWriter.write("<FONT ID=\"Default\">");
                break;
            }
            case 24: {
                hTMLFileWriter.write("<FONT ID=\"Do\">");
                break;
            }
            case 25: {
                hTMLFileWriter.write("<FONT ID=\"Double\">");
                break;
            }
            case 26: {
                hTMLFileWriter.write("<FONT ID=\"Else\">");
                break;
            }
            case 28: {
                hTMLFileWriter.write("<FONT ID=\"Extends\">");
                break;
            }
            case 29: {
                hTMLFileWriter.write("<FONT ID=\"False\">");
                break;
            }
            case 30: {
                hTMLFileWriter.write("<FONT ID=\"Final\">");
                break;
            }
            case 31: {
                hTMLFileWriter.write("<FONT ID=\"Finally\">");
                break;
            }
            case 32: {
                hTMLFileWriter.write("<FONT ID=\"Float\">");
                break;
            }
            case 33: {
                hTMLFileWriter.write("<FONT ID=\"For\">");
                break;
            }
            case 34: {
                hTMLFileWriter.write("<FONT ID=\"Goto\">");
                break;
            }
            case 35: {
                hTMLFileWriter.write("<FONT ID=\"If\">");
                break;
            }
            case 36: {
                hTMLFileWriter.write("<FONT ID=\"Implements\">");
                break;
            }
            case 37: {
                hTMLFileWriter.write("<FONT ID=\"Import\">");
                break;
            }
            case 38: {
                hTMLFileWriter.write("<FONT ID=\"InstanceOf\">");
                break;
            }
            case 39: {
                hTMLFileWriter.write("<FONT ID=\"Int\">");
                break;
            }
            case 40: {
                hTMLFileWriter.write("<FONT ID=\"Interface\">");
                break;
            }
            case 41: {
                hTMLFileWriter.write("<FONT ID=\"Long\">");
                break;
            }
            case 42: {
                hTMLFileWriter.write("<FONT ID=\"Native\">");
                break;
            }
            case 43: {
                hTMLFileWriter.write("<FONT ID=\"New\">");
                break;
            }
            case 44: {
                hTMLFileWriter.write("<FONT ID=\"Null\">");
                break;
            }
            case 45: {
                hTMLFileWriter.write("<FONT ID=\"Package\">");
                break;
            }
            case 46: {
                hTMLFileWriter.write("<FONT ID=\"Private\">");
                break;
            }
            case 47: {
                hTMLFileWriter.write("<FONT ID=\"Protected\">");
                break;
            }
            case 48: {
                hTMLFileWriter.write("<FONT ID=\"Public\">");
                break;
            }
            case 49: {
                hTMLFileWriter.write("<FONT ID=\"Return\">");
                break;
            }
            case 50: {
                hTMLFileWriter.write("<FONT ID=\"Short\">");
                break;
            }
            case 51: {
                hTMLFileWriter.write("<FONT ID=\"Static\">");
                break;
            }
            case 53: {
                hTMLFileWriter.write("<FONT ID=\"Super\">");
                break;
            }
            case 54: {
                hTMLFileWriter.write("<FONT ID=\"Switch\">");
                break;
            }
            case 55: {
                hTMLFileWriter.write("<FONT ID=\"Synchronized\">");
                break;
            }
            case 56: {
                hTMLFileWriter.write("<FONT ID=\"This\">");
                break;
            }
            case 57: {
                hTMLFileWriter.write("<FONT ID=\"Throw\">");
                break;
            }
            case 58: {
                hTMLFileWriter.write("<FONT ID=\"Throws\">");
                break;
            }
            case 59: {
                hTMLFileWriter.write("<FONT ID=\"Transient\">");
                break;
            }
            case 60: {
                hTMLFileWriter.write("<FONT ID=\"True\">");
                break;
            }
            case 61: {
                hTMLFileWriter.write("<FONT ID=\"Try\">");
                break;
            }
            case 62: {
                hTMLFileWriter.write("<FONT ID=\"Void\">");
                break;
            }
            case 63: {
                hTMLFileWriter.write("<FONT ID=\"Volatile\">");
                break;
            }
            case 64: {
                hTMLFileWriter.write("<FONT ID=\"While\">");
                break;
            }
            case 52: {
                hTMLFileWriter.write("<FONT ID=\"StrictFP\">");
                break;
            }
            case 65: {
                hTMLFileWriter.write("<FONT ID=\"IntegerLiteral\">");
                break;
            }
            case 66: {
                hTMLFileWriter.write("<FONT ID=\"DecimalLiteral\">");
                break;
            }
            case 67: {
                hTMLFileWriter.write("<FONT ID=\"HexLiteral\">");
                break;
            }
            case 68: {
                hTMLFileWriter.write("<FONT ID=\"OctalLiteral\">");
                break;
            }
            case 69: {
                hTMLFileWriter.write("<FONT ID=\"FloatPointLiteral\">");
                break;
            }
        }
        hTMLFileWriter.setHTMLMode(true);
    }

    private void tokenColourizeClose(Token token, HTMLFileWriter hTMLFileWriter) {
        hTMLFileWriter.setHTMLMode(false);
        switch (token.kind) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 74: 
            case 75: {
                hTMLFileWriter.write("</FONT>");
            }
        }
        hTMLFileWriter.setHTMLMode(true);
    }

    private String addUnicodeEscapes(String string, Position position) {
        String string2 = "";
        position.column += 5;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            String string3 = JavaCharStream.get(position);
            if (string3 != null) {
                string2 = string2 + "\\u" + string3;
                position.column += 5;
            } else {
                string2 = string2 + c;
            }
            ++n;
            ++position.column;
        }
        return string2;
    }
}

