/*
 * Decompiled with CFR 0.152.
 */
package com.java2html;

import com.java2html.BadOptionException;
import com.java2html.Helper;
import com.java2html.Java2HTML;
import com.java2html.JavaDoc;
import java.io.File;
import java.util.Vector;

public class CommandLineOptionProcessor {
    private String[] args;
    private boolean[] commandLineOptionSet;

    CommandLineOptionProcessor(String[] stringArray) {
        this.args = stringArray;
        this.commandLineOptionSet = new boolean[stringArray.length];
    }

    boolean setOptionsFromCommandLine(Java2HTML java2HTML) throws BadOptionException {
        JavaDoc[] javaDocArray;
        String[] stringArray;
        String[] stringArray2;
        int[] nArray;
        if (this.args.length == 0 || this.getOptionFlag(new String[]{"help", "h", "?", "/?"})) {
            System.out.println(Helper.usage);
            return false;
        }
        String[] stringArray3 = this.getOptionSingleValue(new String[]{"name", "n"}, false, 1);
        if (stringArray3.length == 1) {
            java2HTML.setTitle(stringArray3[0]);
        }
        java2HTML.setFooter(this.getOptionFlag(new String[]{"nofooter", "nf"}));
        java2HTML.setFooter(this.getOptionFlag(new String[]{"noheader", "nh"}));
        java2HTML.setSimple(this.getOptionFlag(new String[]{"simple", "s"}));
        int[] nArray2 = this.getOptionSingleIntegerValue(new String[]{"margin", "m"}, false, 1);
        if (nArray2.length == 1) {
            java2HTML.setMarginSize(nArray2[0]);
        }
        if ((nArray = this.getOptionSingleIntegerValue(new String[]{"tabs", "t"}, false, 1)).length == 1) {
            java2HTML.setTabSize(nArray[0]);
        }
        if ((stringArray2 = this.getOptionSingleValue(new String[]{"destination", "d"}, false, 1)).length == 1) {
            java2HTML.setDestination(stringArray2[0]);
        }
        if ((stringArray = this.getOptionSingleValue(new String[]{"javasource", "js"}, false, -1)).length > 0) {
            java2HTML.setJavaDirectorySource(stringArray);
        }
        if ((javaDocArray = this.getOptionJavaDoc(new String[]{"javadoc", "jd"})).length > 0) {
            java2HTML.setJavaDoc(javaDocArray);
        }
        this.checkForUnkownArgs();
        return true;
    }

    private boolean getOptionFlag(String[] stringArray) throws BadOptionException {
        int n = 0;
        boolean bl = false;
        block0: for (int i = 0; i < this.args.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!this.args[i].equalsIgnoreCase("-" + stringArray[j])) continue;
                this.commandLineOptionSet[i] = true;
                if (n >= 1) {
                    throw new BadOptionException(stringArray[0] + " should only be set once");
                }
                ++n;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    private String[] getOptionSingleValue(String[] stringArray, boolean bl, int n) throws BadOptionException {
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        block0: for (int i = 0; i < this.args.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!this.args[i].equalsIgnoreCase("-" + stringArray[j])) continue;
                this.commandLineOptionSet[i] = true;
                ++i;
                if (n2 == n) {
                    throw new BadOptionException(stringArray[0] + " should only be set " + n + " time(s)");
                }
                if (i >= this.args.length) {
                    throw new BadOptionException("Value not set for " + stringArray[0]);
                }
                this.commandLineOptionSet[i] = true;
                vector.addElement(this.args[i]);
                ++n2;
                continue block0;
            }
        }
        if (bl && n2 == 0) {
            throw new BadOptionException(stringArray[0] + " needs to be set");
        }
        return this.convertToStringArray(vector);
    }

    private int[] getOptionSingleIntegerValue(String[] stringArray, boolean bl, int n) throws BadOptionException {
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        block2: for (int i = 0; i < this.args.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!this.args[i].equalsIgnoreCase("-" + stringArray[j])) continue;
                this.commandLineOptionSet[i] = true;
                ++i;
                if (n2 == n) {
                    throw new BadOptionException(stringArray[0] + " should only be set " + n + " time(s)");
                }
                if (i >= this.args.length) {
                    throw new BadOptionException("Value not set for " + stringArray[0]);
                }
                this.commandLineOptionSet[i] = true;
                vector.addElement(this.args[i]);
                ++n2;
                continue block2;
            }
        }
        if (bl && n2 == 0) {
            throw new BadOptionException(stringArray[0] + " needs to be set");
        }
        int[] nArray = null;
        try {
            nArray = this.convertToIntegerArray(vector);
        }
        catch (Exception exception) {
            throw new BadOptionException(stringArray[0] + " must be a number");
        }
        return nArray;
    }

    public JavaDoc[] getOptionJavaDoc(String[] stringArray) throws BadOptionException {
        int n = 0;
        Vector<JavaDoc> vector = new Vector<JavaDoc>();
        block0: for (int i = 0; i < this.args.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!this.args[i].equalsIgnoreCase("-" + stringArray[j])) continue;
                this.commandLineOptionSet[i] = true;
                if (++i >= this.args.length) {
                    throw new BadOptionException("Value not set for " + stringArray[0]);
                }
                this.commandLineOptionSet[i] = true;
                JavaDoc javaDoc = null;
                File file = new File(this.args[i]);
                String string = null;
                if (i + 1 < this.args.length && !this.args[i + 1].startsWith("-")) {
                    if (!this.args[++i].startsWith("http://")) {
                        throw new BadOptionException("Second Parameter of -jd/-javadoc option must start with 'http://'");
                    }
                    string = this.args[i];
                    this.commandLineOptionSet[i] = true;
                }
                javaDoc = string != null ? new JavaDoc(file, string) : new JavaDoc(file);
                vector.addElement(javaDoc);
                ++n;
                continue block0;
            }
        }
        JavaDoc[] javaDocArray = new JavaDoc[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            javaDocArray[i] = (JavaDoc)vector.elementAt(i);
        }
        return javaDocArray;
    }

    private String[] convertToStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private int[] convertToIntegerArray(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = Integer.parseInt((String)vector.elementAt(i));
        }
        return nArray;
    }

    public void checkForUnkownArgs() throws BadOptionException {
        for (int i = 0; i < this.commandLineOptionSet.length; ++i) {
            if (this.commandLineOptionSet[i]) continue;
            throw new BadOptionException("Unkown Argument :" + this.args[i]);
        }
    }
}

