/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class DecorationPainterUtils {
    private static final String DECORATION_AREA_TYPE = "substancelaf.internal.painter.decorationAreaType";

    public static void setDecorationType(JComponent comp, DecorationAreaType type) {
        comp.putClientProperty(DECORATION_AREA_TYPE, type);
    }

    public static void clearDecorationType(JComponent comp) {
        if (comp != null) {
            comp.putClientProperty(DECORATION_AREA_TYPE, null);
        }
    }

    public static DecorationAreaType getDecorationType(Component comp) {
        for (Component c = comp; c != null; c = c.getParent()) {
            JComponent jc;
            Object prop;
            if (!(c instanceof JComponent) || !((prop = (jc = (JComponent)c).getClientProperty(DECORATION_AREA_TYPE)) instanceof DecorationAreaType)) continue;
            return (DecorationAreaType)prop;
        }
        return DecorationAreaType.NONE;
    }

    public static DecorationAreaType getImmediateDecorationType(Component comp) {
        JComponent jc;
        Object prop;
        Component c = comp;
        if (c instanceof JComponent && (prop = (jc = (JComponent)c).getClientProperty(DECORATION_AREA_TYPE)) instanceof DecorationAreaType) {
            return (DecorationAreaType)prop;
        }
        return null;
    }

    public static void paintDecorationBackground(Graphics g, Component c, boolean force) {
        DecorationAreaType decorationType = SubstanceLookAndFeel.getDecorationType(c);
        DecorationPainterUtils.paintDecorationBackground(g, c, decorationType, force);
    }

    private static void paintDecorationBackground(Graphics g, Component c, DecorationAreaType decorationType, boolean force) {
        boolean isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("lafwidgets.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        if (c.getHeight() == 0 || c.getWidth() == 0) {
            return;
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        SubstanceDecorationPainter painter = skin.getDecorationPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        painter.paintDecorationArea(g2d, c, decorationType, c.getWidth(), c.getHeight(), skin);
        SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
        if (watermark != null && !isPreviewMode && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
            watermark.drawWatermarkImage(g2d, c, 0, 0, c.getWidth(), c.getHeight());
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)c, (float)0.5f, (Graphics)g));
            painter.paintDecorationArea(g2d, c, decorationType, c.getWidth(), c.getHeight(), skin);
        }
        g2d.dispose();
    }
}

