/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.QuaquaUtilities;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.VisualMargin;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorSliderModel;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorTrackImageProducer;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;

public class ColorSliderUI
extends BasicSliderUI
implements TransitionAwareUI {
    private static final Color foreground = new Color(0x949494);
    private static final Color trackBackground = new Color(0xFFFFFF);
    private ColorTrackImageProducer colorTrackImageProducer;
    private Image colorTrackImage;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener substanceRolloverListener;
    private PropertyChangeListener substancePropertyChangeListener;
    protected StateTransitionTracker stateTransitionTracker;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(36, 16);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(26, 100);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 16);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(26, 36);

    public ColorSliderUI(JSlider b) {
        super(b);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        this.thumbModel.setEnabled(b.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(b, this.thumbModel);
    }

    public static ComponentUI createUI(JComponent b) {
        return new ColorSliderUI((JSlider)b);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.focusInsets = new Insets(0, 0, 0, 0);
        slider.setOpaque(false);
        if (slider.getOrientation() == 0) {
            slider.setBorder(new VisualMargin(0, 1, -1, 1));
        } else {
            slider.setBorder(new VisualMargin(0, 0, 0, 1));
        }
        slider.setRequestFocusEnabled(true);
    }

    @Override
    protected void installListeners(final JSlider slider) {
        super.installListeners(slider);
        this.substanceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        slider.addMouseListener(this.substanceRolloverListener);
        slider.addMouseMotionListener(this.substanceRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    ColorSliderUI.this.thumbModel.setEnabled(slider.isEnabled());
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            slider.updateUI();
                        }
                    });
                }
            }
        };
        this.slider.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.substanceRolloverListener);
        slider.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        slider.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
    }

    @Override
    protected Dimension getThumbSize() {
        Icon thumb = this.getThumbIcon();
        return new Dimension(thumb.getIconWidth(), thumb.getIconHeight());
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0) {
            --this.thumbRect.y;
        } else {
            --this.thumbRect.x;
        }
    }

    protected Icon getThumbIcon() {
        if (this.slider.getOrientation() == 0) {
            return UIManager.getIcon("Slider.upThumbSmall");
        }
        return UIManager.getIcon("Slider.leftThumbSmall");
    }

    @Override
    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        int w = knobBounds.width;
        int h = knobBounds.height;
        this.getThumbIcon().paintIcon(this.slider, g, knobBounds.x, knobBounds.y);
    }

    @Override
    public void paintTrack(Graphics g) {
        int ch;
        int cw;
        int cy;
        int cx;
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int pad = this.trackBuffer;
            cx = trackBounds.x - pad + 1;
            cy = trackBounds.y;
            cw = trackBounds.width + pad * 2 - 2;
            ch = trackBounds.height;
        } else {
            int pad = this.trackBuffer;
            cx = trackBounds.x;
            cy = this.contentRect.y + 2;
            cw = trackBounds.width - 1;
            ch = trackBounds.height + pad * 2 - 5;
        }
        g.setColor(trackBackground);
        g.fillRect(cx, cy, cw, ch);
        g.setColor(foreground);
        g.drawRect(cx, cy, cw - 1, ch - 1);
        this.paintColorTrack(g, cx + 2, cy + 2, cw - 4, ch - 4, this.trackBuffer);
    }

    @Override
    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        int w = tickBounds.width;
        int h = tickBounds.height;
        g.setColor(foreground);
        int maj = this.slider.getMajorTickSpacing();
        int min = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            int value;
            g.translate(0, tickBounds.y);
            int xPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMinorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum();
            int yPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    g.translate(-offset, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                value = this.slider.getMinimum();
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    g.translate(2, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMajorTickSpacing();
                }
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.drawLine(x, 0, x, tickBounds.height - 1);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.drawLine(x, 0, x, tickBounds.height - 1);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.drawLine(tickBounds.width / 2, y, tickBounds.width / 2 - 1, y);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.drawLine(0, y, tickBounds.width - 1, y);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    public void paintColorTrack(Graphics g, int x, int y, int width, int height, int buffer) {
        if (this.colorTrackImageProducer == null || this.colorTrackImageProducer.getWidth() != width || this.colorTrackImageProducer.getHeight() != height) {
            if (this.colorTrackImage != null) {
                this.colorTrackImage.flush();
            }
            this.colorTrackImageProducer = new ColorTrackImageProducer(width, height, buffer + 2, this.slider.getOrientation() == 0);
            if (this.slider.getClientProperty("ColorSliderModel") != null) {
                this.colorTrackImageProducer.setColorSliderModel((ColorSliderModel)this.slider.getClientProperty("ColorSliderModel"));
            }
            if (this.slider.getClientProperty("ColorComponentIndex") != null) {
                this.colorTrackImageProducer.setColorComponentIndex((Integer)this.slider.getClientProperty("ColorComponentIndex"));
            }
            this.colorTrackImageProducer.generateColorTrack();
            this.colorTrackImage = this.slider.createImage(this.colorTrackImageProducer);
        } else {
            this.colorTrackImageProducer.regenerateColorTrack();
        }
        g.drawImage(this.colorTrackImage, x, y, this.slider);
    }

    @Override
    protected void calculateTrackRect() {
        int centerSpacing = 0;
        if (this.slider.getOrientation() == 0) {
            centerSpacing = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                centerSpacing += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                centerSpacing += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer + 1;
            this.trackRect.height = 13;
            this.trackRect.y = this.contentRect.y + this.contentRect.height - this.trackRect.height;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2 - 1;
        } else {
            this.trackRect.width = 14;
            this.trackRect.x = this.contentRect.x + this.contentRect.width - this.trackRect.width;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2 + 1;
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y - this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            this.tickRect.width = this.getTickLength();
            this.tickRect.x = this.contentRect.x;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    @Override
    protected int getTickLength() {
        return 4;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return new CSUIPropertyChangeHandler();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new QuaquaTrackListener();
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.thumbRect;
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    public class QuaquaTrackListener
    extends BasicSliderUI.TrackListener {
        public QuaquaTrackListener() {
            super(ColorSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!ColorSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (ColorSliderUI.this.slider.isRequestFocusEnabled()) {
                ColorSliderUI.this.slider.requestFocus();
            }
            if (ColorSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                super.mousePressed(e);
            } else {
                Dimension sbSize = ColorSliderUI.this.slider.getSize();
                boolean direction = true;
                switch (ColorSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        ColorSliderUI.this.slider.setValue(ColorSliderUI.this.valueForYPosition(this.currentMouseY));
                        break;
                    }
                    case 0: {
                        ColorSliderUI.this.slider.setValue(ColorSliderUI.this.valueForXPosition(this.currentMouseX));
                    }
                }
            }
        }
    }

    public class CSUIPropertyChangeHandler
    extends BasicSliderUI.PropertyChangeHandler {
        public CSUIPropertyChangeHandler() {
            super(ColorSliderUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("Frame.active")) {
                ColorSliderUI.this.slider.repaint();
            } else if (propertyName.equals("ColorSliderModel")) {
                if (ColorSliderUI.this.colorTrackImageProducer != null) {
                    ColorSliderUI.this.colorTrackImageProducer.setColorSliderModel((ColorSliderModel)e.getNewValue());
                    if (ColorSliderUI.this.colorTrackImageProducer.needsGeneration()) {
                        ColorSliderUI.this.slider.repaint();
                    }
                }
            } else if (propertyName.equals("snapToTicks")) {
                if (ColorSliderUI.this.colorTrackImageProducer != null) {
                    ColorSliderUI.this.colorTrackImageProducer.markAsDirty();
                    ColorSliderUI.this.slider.repaint();
                }
            } else if (propertyName.equals("ColorComponentIndex")) {
                if (ColorSliderUI.this.colorTrackImageProducer != null && e.getNewValue() != null) {
                    ColorSliderUI.this.colorTrackImageProducer.setColorComponentIndex((Integer)e.getNewValue());
                    if (ColorSliderUI.this.colorTrackImageProducer.needsGeneration()) {
                        ColorSliderUI.this.slider.repaint();
                    }
                }
            } else if (propertyName.equals("ColorComponentChange")) {
                Integer value = (Integer)e.getNewValue();
                if (value != null && ColorSliderUI.this.colorTrackImageProducer != null) {
                    ColorSliderUI.this.colorTrackImageProducer.componentChanged(value);
                    if (ColorSliderUI.this.colorTrackImageProducer.needsGeneration()) {
                        ColorSliderUI.this.slider.repaint();
                    }
                }
            } else if (propertyName.equals("ColorComponentValue")) {
                Integer value = (Integer)ColorSliderUI.this.slider.getClientProperty("ColorComponentChange");
                if (value != null && ColorSliderUI.this.colorTrackImageProducer != null) {
                    ColorSliderUI.this.colorTrackImageProducer.componentChanged(value);
                    if (ColorSliderUI.this.colorTrackImageProducer.needsGeneration()) {
                        ColorSliderUI.this.slider.repaint();
                    }
                }
            } else if (propertyName.equals("Orientation")) {
                if (ColorSliderUI.this.slider.getOrientation() == 0) {
                    ColorSliderUI.this.slider.setBorder(new VisualMargin(0, 1, -1, 1));
                } else {
                    ColorSliderUI.this.slider.setBorder(new VisualMargin(0, 0, 0, 1));
                }
            }
            super.propertyChange(e);
        }
    }
}

