/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import apple.awt.CWindow;
import apple.awt.ComponentModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.image.ColorModel;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.CGLGraphicsConfig;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLSurfaceData;

public abstract class CGLSurfaceData
extends OGLSurfaceData {
    protected ComponentModel peer;
    private CGLGraphicsConfig graphicsConfig;

    private static native void initIDs(Class var0, Object var1);

    private native void initOps(ComponentModel var1, CGLGraphicsConfig var2);

    protected native boolean initWindow(long var1, long var3, long var5, int var7, int var8);

    protected native boolean initPbuffer(long var1, long var3, int var5, int var6);

    protected CGLSurfaceData(ComponentModel componentModel, CGLGraphicsConfig cGLGraphicsConfig, SurfaceType surfaceType, ColorModel colorModel, int n) {
        super(surfaceType, colorModel, n);
        this.peer = componentModel;
        this.graphicsConfig = cGLGraphicsConfig;
        this.solidloops = this.graphicsConfig.getSolidLoops(surfaceType);
        this.initOps(componentModel, this.graphicsConfig);
    }

    public boolean initWindow() {
        int n;
        int n2;
        Component component = this.peer.getTarget();
        if (component instanceof Container) {
            Insets insets = ((Container)component).getInsets();
            n2 = insets.left;
            n = insets.top;
        } else {
            n = 0;
            n2 = 0;
        }
        long l = this.peer.getData();
        long l2 = this.graphicsConfig.getNativeConfigInfo();
        if (this.initWindow(this.getNativeOps(), l, l2, n2, n)) {
            if (this.type == 0) {
                this.type = 1;
            }
            return true;
        }
        return false;
    }

    protected boolean initPixmap(long l, long l2, int n, int n2, int n3) {
        return false;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public OGLContext getContext() {
        return this.graphicsConfig.getContext();
    }

    public long getSharedContext() {
        CGLSurfaceData cGLSurfaceData = this;
        return cGLSurfaceData.graphicsConfig.getThreadSharedContext();
    }

    public boolean isBlendPremultAvailable() {
        return this.graphicsConfig.isBlendPremultAvailable();
    }

    public boolean isTexNonPow2Available() {
        return this.graphicsConfig.isTexNonPow2Available();
    }

    public static CGLWindowSurfaceData createData(ComponentModel componentModel) {
        CGLGraphicsConfig cGLGraphicsConfig = CGLSurfaceData.getGC(componentModel);
        return new CGLWindowSurfaceData(componentModel, null, cGLGraphicsConfig, componentModel.getBounds());
    }

    public static CGLWindowSurfaceData createData(ComponentModel componentModel, CWindow cWindow, Rectangle rectangle) {
        CGLGraphicsConfig cGLGraphicsConfig = CGLSurfaceData.getGC(componentModel);
        return new CGLWindowSurfaceData(componentModel, cWindow, cGLGraphicsConfig, rectangle);
    }

    public static CGLOffScreenSurfaceData createData(ComponentModel componentModel, boolean bl) {
        CGLGraphicsConfig cGLGraphicsConfig = CGLSurfaceData.getGC(componentModel);
        Rectangle rectangle = componentModel.getBounds();
        int n = bl ? 6 : 5;
        return new CGLOffScreenSurfaceData(componentModel, cGLGraphicsConfig, rectangle.width, rectangle.height, null, componentModel.getColorModel(), n);
    }

    public static CGLOffScreenSurfaceData createData(CGLGraphicsConfig cGLGraphicsConfig, int n, int n2, ColorModel colorModel, Image image, int n3) {
        return new CGLOffScreenSurfaceData(null, cGLGraphicsConfig, n, n2, image, colorModel, n3);
    }

    public static CGLGraphicsConfig getGC(ComponentModel componentModel) {
        if (componentModel != null) {
            return (CGLGraphicsConfig)componentModel.getGraphicsConfiguration();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return (CGLGraphicsConfig)graphicsDevice.getDefaultConfiguration();
    }

    static {
        CGLSurfaceData.initIDs(CGLGraphicsConfig.class, OGLContext.LOCK);
    }

    public static class CGLOffScreenSurfaceData
    extends CGLSurfaceData {
        private Image offscreenImage;
        private int width;
        private int height;
        private int transparency;

        public CGLOffScreenSurfaceData(ComponentModel componentModel, CGLGraphicsConfig cGLGraphicsConfig, int n, int n2, Image image, ColorModel colorModel, int n3) {
            super(componentModel, cGLGraphicsConfig, n3 == 4 ? OpenGLTexture : (n3 == 3 ? OpenGLSurfaceRTT : OpenGLSurface), colorModel, n3);
            this.width = n;
            this.height = n2;
            this.offscreenImage = image;
            this.transparency = colorModel.getTransparency();
            this.initSurface(n, n2, this.depth);
        }

        public SurfaceData getReplacement() {
            return CGLOffScreenSurfaceData.restoreContents(this.offscreenImage);
        }

        public int getTransparency() {
            return this.transparency;
        }

        public Rectangle getBounds() {
            if (this.type == 6) {
                Rectangle rectangle = this.peer.getBounds();
                rectangle.y = 0;
                rectangle.x = 0;
                return rectangle;
            }
            return new Rectangle(this.width, this.height);
        }
    }

    public static class CGLWindowSurfaceData
    extends CGLSurfaceData {
        CWindow cwindow;
        Rectangle surfaceBounds;
        private InvocationEvent flushEvt;
        private boolean flushPending = false;

        public CGLWindowSurfaceData(ComponentModel componentModel, CWindow cWindow, CGLGraphicsConfig cGLGraphicsConfig, Rectangle rectangle) {
            super(componentModel, cGLGraphicsConfig, OpenGLSurface, componentModel.getColorModel(), 0);
            this.surfaceBounds = rectangle;
            this.cwindow = cWindow;
        }

        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        public Rectangle getBounds() {
            return this.surfaceBounds;
        }

        public void validatePipe(SunGraphics2D sunGraphics2D) {
            super.validatePipe(sunGraphics2D);
            if (this.cwindow.isFlushingAllowed()) {
                this.invokeNativeGLFlush();
            }
        }

        void invokeNativeGLFlush() {
            if (!this.flushPending) {
                this.flushPending = true;
                if (this.flushEvt == null) {
                    this.flushEvt = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), new NativeGLFlush());
                }
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(this.flushEvt);
            }
        }

        private class NativeGLFlush
        implements Runnable {
            private NativeGLFlush() {
            }

            public void run() {
                CGLWindowSurfaceData cGLWindowSurfaceData = CGLWindowSurfaceData.this;
                OGLContext oGLContext = CGLWindowSurfaceData.this.getContext();
                oGLContext.makeCurrent(cGLWindowSurfaceData, cGLWindowSurfaceData);
                CGLWindowSurfaceData.this.cwindow.disableFlushing();
                CGLWindowSurfaceData.this.cwindow.enableFlushing();
                CGLWindowSurfaceData.this.flushPending = false;
                oGLContext.invalidateCurrentContext();
            }
        }
    }
}

