/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import apple.awt.CGraphicsConfig;
import apple.awt.CGraphicsDevice;
import apple.awt.CGraphicsEnvironment;
import apple.awt.ComponentModel;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.image.SunVolatileImage;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.CGLContext;
import sun.java2d.opengl.CGLOffScreenImage;
import sun.java2d.opengl.CGLSurfaceData;
import sun.java2d.opengl.OGLContext;

public class CGLGraphicsConfig
extends CGraphicsConfig {
    protected static boolean cglAvailable;
    private static ImageCapabilities imageCaps;
    protected RenderLoops solidloops;
    protected long pixelFormat;
    protected boolean doubleBuffer;
    protected boolean blendPremultAvailable;
    protected boolean texNonPow2Available;
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private ThreadLocal<OGLContext> contextTls = new ThreadLocal<OGLContext>(){

        @Override
        protected OGLContext initialValue() {
            return new CGLContext(CGLGraphicsConfig.this);
        }
    };
    private static ThreadLocal<Long> sharedContextTls;
    private SurfaceType sTypeOrig = null;

    public static native long getDefaultPixFmt(int var0);

    private static native boolean initCGL();

    private static native long getCGLConfigInfo(int var0, long var1);

    private static native boolean isDoubleBuffered(long var0);

    private static native boolean isBlendPremultAvailable(long var0);

    private static native boolean isTexNonPow2Available(long var0);

    protected CGLGraphicsConfig(CGraphicsDevice cGraphicsDevice, long l, boolean bl, long l2) {
        super(cGraphicsDevice);
        this.pixelFormat = l;
        this.pConfigInfo = l2;
        this.doubleBuffer = bl;
        this.blendPremultAvailable = CGLGraphicsConfig.isBlendPremultAvailable(l2);
        this.texNonPow2Available = CGLGraphicsConfig.isTexNonPow2Available(l2);
    }

    public static CGLGraphicsConfig getConfig(CGraphicsDevice cGraphicsDevice) {
        return CGLGraphicsConfig.getConfig(cGraphicsDevice, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CGLGraphicsConfig getConfig(CGraphicsDevice cGraphicsDevice, long l) {
        if (!cglAvailable) {
            return null;
        }
        long l2 = 0L;
        Object object = OGLContext.LOCK;
        synchronized (object) {
            l2 = CGLGraphicsConfig.getCGLConfigInfo(cGraphicsDevice.getScreen(), l);
        }
        if (l2 == 0L) {
            return null;
        }
        boolean bl = CGLGraphicsConfig.isDoubleBuffered(l2);
        return new CGLGraphicsConfig(cGraphicsDevice, l, bl, l2);
    }

    public static boolean isCGLAvailable() {
        return cglAvailable;
    }

    public boolean isBlendPremultAvailable() {
        return this.blendPremultAvailable;
    }

    public boolean isTexNonPow2Available() {
        return this.texNonPow2Available;
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffer;
    }

    public long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    public final OGLContext getContext() {
        return this.contextTls.get();
    }

    private static native long initNativeSharedContext();

    private static native long makeNativeSharedContextCurrent(long var0);

    public static long getThreadSharedContext() {
        long l = sharedContextTls.get();
        return CGLGraphicsConfig.makeNativeSharedContextCurrent(l);
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public SurfaceData createSurfaceData(ComponentModel componentModel, int n) {
        return CGLSurfaceData.createData(componentModel);
    }

    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new CGLOffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    private native void swapBuffers(long var1);

    public void assertOperationSupported(Component component, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (bufferCapabilities.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
    }

    public VolatileImage createBackBuffer(ComponentModel componentModel) {
        Component component = componentModel.getTarget();
        return new SunVolatileImage(component, component.getWidth(), component.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(ComponentModel componentModel, Component component, VolatileImage volatileImage, BufferCapabilities.FlipContents flipContents) {
        Thread.dumpStack();
        long l = 0L;
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            Graphics graphics = componentModel.getGraphics();
            try {
                graphics.drawImage(volatileImage, 0, 0, null);
            }
            finally {
                graphics.dispose();
            }
            return;
        }
        if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        Object object = OGLContext.LOCK;
        synchronized (object) {
            this.swapBuffers(l);
        }
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            object = volatileImage.getGraphics();
            try {
                ((Graphics)object).setColor(component.getBackground());
                ((Graphics)object).fillRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            }
            finally {
                ((Graphics)object).dispose();
            }
        }
    }

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new CGLCapabilities(this.doubleBuffer);
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    public synchronized RenderLoops getSolidLoops(SurfaceType surfaceType) {
        if (this.solidloops == null || this.sTypeOrig != surfaceType) {
            this.solidloops = SurfaceData.makeRenderLoops(SurfaceType.OpaqueColor, CompositeType.SrcNoEa, surfaceType);
            this.sTypeOrig = surfaceType;
        }
        return this.solidloops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        imageCaps = new ImageCapabilities(true);
        OGLContext.LOCK = CGraphicsEnvironment.class;
        Object object = OGLContext.LOCK;
        synchronized (object) {
            cglAvailable = CGLGraphicsConfig.initCGL();
        }
        sharedContextTls = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return new Long(CGLGraphicsConfig.initNativeSharedContext());
            }
        };
    }

    private static class CGLCapabilities
    extends BufferCapabilities {
        public CGLCapabilities(boolean bl) {
            super(imageCaps, imageCaps, bl ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }
}

