/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import apple.awt.CGraphicsEnvironment;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import sun.awt.DisplayChangedListener;
import sun.awt.image.CachingSurfaceManager;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.opengl.CGLGraphicsConfig;
import sun.java2d.opengl.CGLSurfaceData;

public class CGLCachingSurfaceManager
extends CachingSurfaceManager
implements DisplayChangedListener {
    private int transparency;

    public CGLCachingSurfaceManager(BufferedImage bufferedImage) {
        super(bufferedImage);
        Object object;
        this.transparency = bufferedImage.getColorModel().getTransparency();
        if (accelerationThreshold == 0 && this.localAccelerationEnabled) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.initAcceleratedSurface((GraphicsConfiguration)object, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        if ((object = GraphicsEnvironment.getLocalGraphicsEnvironment()) instanceof CGraphicsEnvironment) {
            ((CGraphicsEnvironment)object).addDisplayChangedListener(this);
        }
    }

    protected SurfaceData getAccelSurface(GraphicsConfiguration graphicsConfiguration) {
        return this.accelSurfaces != null ? (SurfaceData)this.accelSurfaces.get(graphicsConfiguration) : null;
    }

    protected boolean isDestSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof CGLSurfaceData;
    }

    protected boolean isOperationSupported(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        boolean bl2 = surfaceData instanceof CGLSurfaceData && (color == null || this.transparency == 1);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAcceleratedSurface(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        CGLCachingSurfaceManager cGLCachingSurfaceManager = this;
        synchronized (cGLCachingSurfaceManager) {
            try {
                this.sdAccel = this.getAccelSurface(graphicsConfiguration);
                if (this.sdAccel == null) {
                    if (graphicsConfiguration instanceof CGLGraphicsConfig) {
                        this.sdAccel = this.createAccelSurface(graphicsConfiguration, n, n2);
                    }
                    if (this.sdAccel != null) {
                        this.accelSurfaces.put(graphicsConfiguration, this.sdAccel);
                    }
                }
            }
            catch (InvalidPipeException invalidPipeException) {
                this.sdAccel = null;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.sdAccel = null;
            }
        }
    }

    protected SurfaceData createAccelSurface(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        return CGLSurfaceData.createData((CGLGraphicsConfig)graphicsConfiguration, n, n2, graphicsConfiguration.getColorModel(), this.bImg, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayChanged() {
        if (!accelerationEnabled) {
            return;
        }
        CGLCachingSurfaceManager cGLCachingSurfaceManager = this;
        synchronized (cGLCachingSurfaceManager) {
            if (this.sdAccel != null) {
                Hashtable hashtable = this.accelSurfaces;
                this.sdAccel = null;
                this.accelSurfaces = new Hashtable();
                if (hashtable != null) {
                    Object[] objectArray = hashtable.values().toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((SurfaceData)objectArray[i]).invalidate();
                    }
                }
            }
        }
    }

    public void paletteChanged() {
        this.sdDefault.setNeedsBackup(true);
    }

    public synchronized void flush() {
        this.sdAccel = null;
        if (this.accelSurfaces != null) {
            Hashtable hashtable = this.accelSurfaces;
            this.accelSurfaces = new Hashtable();
            Object[] objectArray = hashtable.values().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((CGLSurfaceData)objectArray[i]).flush();
            }
        }
    }

    public void rasterRead() {
    }

    public void rasterRead(int n, int n2) {
    }

    public void rasterWrite() {
        this.rasterChanged();
    }

    public void imageOnlyAccess() {
    }

    public String toString() {
        return new String("CGLCachingSurfaceManager@" + Integer.toHexString(this.hashCode()) + " transparency: " + (this.transparency == 1 ? "OPAQUE" : (this.transparency == 2 ? "BITMASK" : "TRANSLUCENT")));
    }
}

