/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CColorPaint;
import apple.awt.CRenderer;
import apple.awt.CTextPipe;
import apple.awt.ComponentModel;
import apple.awt.CompositeCRenderer;
import apple.awt.OSXOffScreenSurfaceData;
import apple.awt.RuntimeOptions;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.swing.plaf.ColorUIResource;
import sun.awt.SunHints;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;

public abstract class OSXSurfaceData
extends SurfaceData {
    protected static final int fRenderer = RuntimeOptions.getCurrentOptions().Renderer;
    protected static CRenderer sQuartzPipe = null;
    protected static CTextPipe sCocoaTextPipe = null;
    protected static CompositeCRenderer sQuartzCompositePipe = null;
    private GraphicsConfiguration fConfig;
    private Rectangle fBounds;
    GraphicsConfiguration sDefaultGraphicsConfiguration = null;
    BufferedImage sSrcComposite = null;
    BufferedImage sDstInComposite = null;
    BufferedImage sDstOutComposite = null;
    DrawingQueue fDrawingQueue = null;
    static final int kPrimitive = 0;
    static final int kImage = 1;
    static final int kText = 2;
    static final int kCopyArea = 3;
    static final int kExternal = 4;
    static final int kLine = 5;
    static final int kRect = 6;
    static final int kRoundRect = 7;
    static final int kOval = 8;
    static final int kArc = 9;
    static final int kPolygon = 10;
    static final int kShape = 11;
    static final int kString = 13;
    static final int kGlyphs = 14;
    static final int kUnicodes = 15;
    static final int kCommonParameterCount = 10;
    static final int kLineParametersCount = 10;
    static final int kRectParametersCount = 11;
    static final int kRoundRectParametersCount = 13;
    static final int kOvalParametersCount = 11;
    static final int kArcParametersCount = 14;
    static final int kPolygonParametersCount = 0;
    static final int kShapeParametersCount = 0;
    static final int kImageParametersCount = 22;
    static final int kStringParametersCount = 0;
    static final int kGlyphsParametersCount = 0;
    static final int kUnicodesParametersCount = 0;
    static final int kPixelParametersCount = 0;
    static final int kExternalParametersCount = 0;
    static final int kChangeFlagIndex = 0;
    static final int kBoundsXIndex = 1;
    static final int kBoundsYIndex = 2;
    static final int kBoundsWidthIndex = 3;
    static final int kBoundsHeightIndex = 4;
    static final int kClipStateIndex = 5;
    static final int kClipNumTypesIndex = 6;
    static final int kClipNumCoordsIndex = 7;
    static final int kClipWindingRuleIndex = 8;
    static final int kClipXIndex = 9;
    static final int kClipYIndex = 10;
    static final int kClipWidthIndex = 11;
    static final int kClipHeightIndex = 12;
    static final int kCTMaIndex = 13;
    static final int kCTMbIndex = 14;
    static final int kCTMcIndex = 15;
    static final int kCTMdIndex = 16;
    static final int kCTMtxIndex = 17;
    static final int kCTMtyIndex = 18;
    static final int kColorStateIndex = 19;
    static final int kColorRGBValueIndex = 20;
    static final int kColorIndexValueIndex = 21;
    static final int kColorPointerIndex = 22;
    static final int kColorPointerIndex2 = 23;
    static final int kColorRGBValue1Index = 24;
    static final int kColorWidthIndex = 25;
    static final int kColorRGBValue2Index = 26;
    static final int kColorHeightIndex = 27;
    static final int kColorIsCyclicIndex = 28;
    static final int kColorx1Index = 29;
    static final int kColortxIndex = 30;
    static final int kColory1Index = 31;
    static final int kColortyIndex = 32;
    static final int kColorx2Index = 33;
    static final int kColorsxIndex = 34;
    static final int kColory2Index = 35;
    static final int kColorsyIndex = 36;
    static final int kCompositeRuleIndex = 37;
    static final int kCompositeValueIndex = 38;
    static final int kStrokeJoinIndex = 39;
    static final int kStrokeCapIndex = 40;
    static final int kStrokeWidthIndex = 41;
    static final int kStrokeDashPhaseIndex = 42;
    static final int kStrokeLimitIndex = 43;
    static final int kHintsAntialiasIndex = 44;
    static final int kHintsTextAntialiasIndex = 45;
    static final int kHintsFractionalMetricsIndex = 46;
    static final int kHintsRenderingIndex = 47;
    static final int kHintsInterpolationIndex = 48;
    static final int kCanDrawDuringLiveResizeIndex = 49;
    static final int kSizeOfParameters = 50;
    static final int kClipCoordinatesIndex = 0;
    static final int kClipTypesIndex = 1;
    static final int kTextureImageIndex = 2;
    static final int kStrokeDashArrayIndex = 3;
    static final int kFontIndex = 4;
    static final int kFontPaintIndex = 5;
    static final int kBoundsChangedBit = 1;
    static final int kBoundsNotChangedBit = -2;
    static final int kClipChangedBit = 2;
    static final int kClipNotChangedBit = -3;
    static final int kCTMChangedBit = 4;
    static final int kCTMNotChangedBit = -5;
    static final int kColorChangedBit = 8;
    static final int kColorNotChangedBit = -9;
    static final int kCompositeChangedBit = 16;
    static final int kCompositeNotChangedBit = -17;
    static final int kStrokeChangedBit = 32;
    static final int kStrokeNotChangedBit = -33;
    static final int kHintsChangedBit = 64;
    static final int kHintsNotChangedBit = -65;
    static final int kFontChangedBit = 128;
    static final int kFontNotChangedBit = -129;
    static final int kEverythingChangedFlag = -1;
    static final int kColorSimple = 0;
    static final int kColorAqua = 1;
    static final int kColorSystem = 2;
    static final int kColorGradient = 3;
    static final int kColorTexture = 4;
    static final int kColorNonCyclic = 0;
    static final int kColorCyclic = 1;
    static final int kClipRect = 0;
    static final int kClipShape = 1;
    int fChangeFlag;
    protected ByteBuffer fGraphicsStates = null;
    IntBuffer fGraphicsStatesInt = null;
    FloatBuffer fGraphicsStatesFloat = null;
    LongBuffer fGraphicsStatesLong = null;
    protected Object[] fGraphicsStatesObject = null;
    public int seedBounds = 0;
    public int seedClip = 0;
    public int seedTransform = 0;
    public int seedPaint = 0;
    public int seedComposite = 0;
    public int seedStroke = 0;
    public int seedFont = 0;
    public int seedRenderingHints = 0;
    private int seedUserBounds = 0;
    private int lastSeedUserBounds = 0;
    Rectangle userBounds = new Rectangle();
    float lastUserX = 0.0f;
    float lastUserY = 0.0f;
    float lastUserW = 0.0f;
    float lastUserH = 0.0f;
    FloatBuffer clipCoordinatesArray = null;
    IntBuffer clipTypesArray = null;
    Shape lastClipShape = null;
    float lastClipX = 0.0f;
    float lastClipY = 0.0f;
    float lastClipW = 0.0f;
    float lastClipH = 0.0f;
    final double[] lastCTM = new double[6];
    float lastCTMa = 0.0f;
    float lastCTMb = 0.0f;
    float lastCTMc = 0.0f;
    float lastCTMd = 0.0f;
    float lastCTMtx = 0.0f;
    float lastCTMty = 0.0f;
    static AffineTransform sIdentityMatrix;
    Paint lastPaint = null;
    long lastPaintPtr = 0L;
    int lastPaintRGB = 0;
    int lastPaintIndex = 0;
    BufferedImage texturePaintImage = null;
    Rectangle customPaintBounds = new Rectangle();
    Composite lastComposite;
    int lastCompositeAlphaRule = 0;
    float lastCompositeAlphaValue = 0.0f;
    BasicStroke lastStroke = null;
    static BasicStroke defaultBasicStroke;
    Font lastFont;
    Object hintValue;
    SunGraphics2D sg2dCurrent = null;
    Thread threadCurrent = null;
    final float[] segmentCoordinatesArray = new float[6];
    FloatBuffer shapeCoordinatesArray = null;
    IntBuffer shapeTypesArray = null;
    Rectangle srcCopyAreaRect = new Rectangle();
    Rectangle dstCopyAreaRect = new Rectangle();
    Rectangle finalCopyAreaRect = new Rectangle();
    Rectangle copyAreaBounds = new Rectangle();
    static final int kMinQueueSize;
    static final int kQueueSizeMultiplier;
    static final int kMaxQueueSize;
    static final int kQueueSizeGrowFlush;

    static native void init(boolean var0, boolean var1);

    public OSXSurfaceData(SurfaceType surfaceType, ColorModel colorModel) {
        this(surfaceType, colorModel, null, new Rectangle());
    }

    public OSXSurfaceData(SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Rectangle rectangle) {
        super(surfaceType, colorModel);
        this.fConfig = graphicsConfiguration;
        this.fBounds = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.y + rectangle.height);
        ++this.seedUserBounds;
        this.fGraphicsStates = OSXSurfaceData.getBufferOfSize(50);
        this.fGraphicsStatesInt = this.fGraphicsStates.asIntBuffer();
        this.fGraphicsStatesFloat = this.fGraphicsStates.asFloatBuffer();
        this.fGraphicsStatesLong = this.fGraphicsStates.asLongBuffer();
        this.fGraphicsStatesObject = new Object[6];
        this.fDrawingQueue = new DrawingQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        switch (fRenderer) {
            case 3: {
                System.err.println("OpenGL pipeline should never reach here!");
                Thread.dumpStack();
                break;
            }
            case 2: {
                super.validatePipe(sunGraphics2D);
                if (!(sunGraphics2D.paint instanceof CColorPaint) && !(sunGraphics2D.paint instanceof SystemColor)) break;
                this.fDrawingQueue.disableLazyDrawing();
                if (sunGraphics2D.compositeState <= 1) {
                    if (sQuartzPipe == null) {
                        sQuartzPipe = new CRenderer();
                    }
                    sunGraphics2D.drawpipe = sQuartzPipe;
                    sunGraphics2D.fillpipe = sQuartzPipe;
                    sunGraphics2D.shapepipe = sQuartzPipe;
                    break;
                }
                if (sQuartzCompositePipe == null) {
                    sQuartzCompositePipe = new CompositeCRenderer();
                }
                sunGraphics2D.drawpipe = sQuartzCompositePipe;
                sunGraphics2D.fillpipe = sQuartzCompositePipe;
                sunGraphics2D.shapepipe = sQuartzCompositePipe;
                break;
            }
            default: {
                Object object = this.getLockObject();
                synchronized (object) {
                    if (sunGraphics2D.compositeState <= 1) {
                        if (sQuartzPipe == null) {
                            sQuartzPipe = new CRenderer();
                        }
                        if (sCocoaTextPipe == null) {
                            sCocoaTextPipe = new CTextPipe();
                        }
                        sunGraphics2D.imagepipe = sQuartzPipe;
                        sunGraphics2D.drawpipe = sQuartzPipe;
                        sunGraphics2D.fillpipe = sQuartzPipe;
                        sunGraphics2D.shapepipe = sQuartzPipe;
                        sunGraphics2D.textpipe = sCocoaTextPipe;
                    } else {
                        if (sQuartzCompositePipe == null) {
                            sQuartzCompositePipe = new CompositeCRenderer();
                        }
                        sunGraphics2D.imagepipe = sQuartzCompositePipe;
                        sunGraphics2D.drawpipe = sQuartzCompositePipe;
                        sunGraphics2D.fillpipe = sQuartzCompositePipe;
                        sunGraphics2D.shapepipe = sQuartzCompositePipe;
                        sunGraphics2D.textpipe = sCocoaTextPipe;
                    }
                    break;
                }
            }
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height - this.fBounds.y);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.fConfig;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        throw new InternalError("not implemented yet");
    }

    public void lock() {
        throw new InternalError("not implemented yet");
    }

    public void unlock() {
        throw new InternalError("not implemented yet");
    }

    public Object getLockObject() {
        return this;
    }

    protected void setBounds(int n, int n2, int n3, int n4) {
        this.fBounds.reshape(n, n2, n3, n2 + n4);
        ++this.seedUserBounds;
    }

    public BufferedImage copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, BufferedImage bufferedImage) {
        throw new InternalError("subclass using unimplemented method");
    }

    public boolean xorSurfacePixels(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5) {
        throw new InternalError("subclass using unimplemented method");
    }

    protected BufferedImage getCompositingImage(int n, int n2) {
        if (this.sDefaultGraphicsConfiguration == null) {
            this.sDefaultGraphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)BufImgSurfaceData.createData(bufferedImage);
        oSXSurfaceData.disableLazyDrawing();
        return bufferedImage;
    }

    protected BufferedImage getCompositingImageBiggerOrSame(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null || bufferedImage.getWidth() < n || bufferedImage.getHeight() < n2) {
            bufferedImage = this.getCompositingImage(n, n2);
        } else {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)BufImgSurfaceData.createData(bufferedImage);
            oSXSurfaceData.clearRect(bufferedImage, n, n2);
        }
        return bufferedImage;
    }

    protected BufferedImage getCompositingImageSame(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null || bufferedImage.getWidth() != n || bufferedImage.getHeight() != n2) {
            bufferedImage = this.getCompositingImage(n, n2);
        } else {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)BufImgSurfaceData.createData(bufferedImage);
            oSXSurfaceData.clearRect(bufferedImage, n, n2);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getCompositingSrcImage(int n, int n2) {
        Object object = this.getLockObject();
        synchronized (object) {
            BufferedImage bufferedImage;
            this.sSrcComposite = bufferedImage = this.getCompositingImageSame(this.sSrcComposite, n, n2);
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getCompositingDstInImage(int n, int n2) {
        Object object = this.getLockObject();
        synchronized (object) {
            BufferedImage bufferedImage;
            this.sDstInComposite = bufferedImage = this.getCompositingImageSame(this.sDstInComposite, n, n2);
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getCompositingDstOutImage(int n, int n2) {
        Object object = this.getLockObject();
        synchronized (object) {
            BufferedImage bufferedImage;
            this.sDstOutComposite = bufferedImage = this.getCompositingImageSame(this.sDstOutComposite, n, n2);
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRect(BufferedImage bufferedImage, int n, int n2) {
        Object object = this.getLockObject();
        synchronized (object) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.dispose();
        }
    }

    public void invalidate() {
    }

    ComponentModel getPeer() {
        return null;
    }

    static int getRendererTypeForPrimitive(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 13: 
            case 14: 
            case 15: {
                return 2;
            }
        }
        return 0;
    }

    void setUserBounds(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        if (this.lastUserX != (float)n || this.lastUserY != (float)n2 || this.lastUserW != (float)n3 || this.lastUserH != (float)n4) {
            this.lastUserX = n;
            this.lastUserY = n2;
            this.lastUserW = n3;
            this.lastUserH = n4;
            this.fGraphicsStatesInt.put(1, n);
            this.fGraphicsStatesInt.put(2, n2);
            this.fGraphicsStatesInt.put(3, n3);
            this.fGraphicsStatesInt.put(4, n4);
            this.userBounds.setBounds(n, n2, n3, n4);
            this.fChangeFlag |= 1;
        } else {
            this.fChangeFlag &= 0xFFFFFFFE;
        }
    }

    void setupClip(SunGraphics2D sunGraphics2D) {
        switch (sunGraphics2D.clipState) {
            case 0: 
            case 1: {
                Region region = sunGraphics2D.getCompClip();
                float f = region.getLoX();
                float f2 = region.getLoY();
                float f3 = region.getWidth();
                float f4 = region.getHeight();
                if (this.fGraphicsStatesInt.get(5) != 0 || f != this.lastClipX || f2 != this.lastClipY || f3 != this.lastClipW || f4 != this.lastClipH) {
                    this.fGraphicsStatesFloat.put(9, f);
                    this.fGraphicsStatesFloat.put(10, f2);
                    this.fGraphicsStatesFloat.put(11, f3);
                    this.fGraphicsStatesFloat.put(12, f4);
                    this.lastClipX = f;
                    this.lastClipY = f2;
                    this.lastClipW = f3;
                    this.lastClipH = f4;
                    this.fChangeFlag |= 2;
                } else {
                    this.fChangeFlag &= 0xFFFFFFFD;
                }
                this.fGraphicsStatesInt.put(5, 0);
                break;
            }
            case 2: {
                this.lastClipShape = sunGraphics2D.usrClip;
                GeneralPath generalPath = null;
                generalPath = sunGraphics2D.usrClip instanceof GeneralPath ? (GeneralPath)sunGraphics2D.usrClip : new GeneralPath(sunGraphics2D.usrClip);
                int n = this.getPathLength(generalPath);
                if (this.clipCoordinatesArray == null || this.clipCoordinatesArray.capacity() < n * 6) {
                    this.clipCoordinatesArray = OSXSurfaceData.getBufferOfSize(n * 6).asFloatBuffer();
                }
                if (this.clipTypesArray == null || this.clipTypesArray.capacity() < n) {
                    this.clipTypesArray = OSXSurfaceData.getBufferOfSize(n).asIntBuffer();
                }
                int n2 = this.getPathCoordinates(generalPath, this.clipCoordinatesArray, this.clipTypesArray);
                this.fGraphicsStatesInt.put(6, this.clipTypesArray.position());
                this.fGraphicsStatesInt.put(7, this.clipCoordinatesArray.position());
                this.fGraphicsStatesInt.put(8, n2);
                this.fGraphicsStatesObject[1] = this.clipTypesArray;
                this.fGraphicsStatesObject[0] = this.clipCoordinatesArray;
                this.fChangeFlag |= 2;
                this.fGraphicsStatesInt.put(5, 1);
            }
        }
        this.seedClip = sunGraphics2D.seedClip;
    }

    void setupTransform(SunGraphics2D sunGraphics2D) {
        sunGraphics2D.transform.getMatrix(this.lastCTM);
        float f = (float)this.lastCTM[0];
        float f2 = (float)this.lastCTM[1];
        float f3 = (float)this.lastCTM[2];
        float f4 = (float)this.lastCTM[3];
        float f5 = (float)this.lastCTM[4];
        float f6 = (float)this.lastCTM[5];
        if (f5 != this.lastCTMtx || f6 != this.lastCTMty || f != this.lastCTMa || f2 != this.lastCTMb || f3 != this.lastCTMc || f4 != this.lastCTMd) {
            this.fGraphicsStatesFloat.put(13, f);
            this.fGraphicsStatesFloat.put(14, f2);
            this.fGraphicsStatesFloat.put(15, f3);
            this.fGraphicsStatesFloat.put(16, f4);
            this.fGraphicsStatesFloat.put(17, f5);
            this.fGraphicsStatesFloat.put(18, f6);
            this.lastCTMa = f;
            this.lastCTMb = f2;
            this.lastCTMc = f3;
            this.lastCTMd = f4;
            this.lastCTMtx = f5;
            this.lastCTMty = f6;
            this.fChangeFlag |= 4;
        } else {
            this.fChangeFlag &= 0xFFFFFFFB;
        }
        this.seedTransform = sunGraphics2D.seedTransform;
    }

    void setupPaint(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        if (sunGraphics2D.paint instanceof SystemColor) {
            SystemColor systemColor = (SystemColor)sunGraphics2D.paint;
            int n5 = systemColor.hashCode();
            if (this.fGraphicsStatesInt.get(19) != 2 || n5 != this.lastPaintIndex) {
                this.lastPaintIndex = n5;
                this.fGraphicsStatesInt.put(19, 2);
                this.fGraphicsStatesInt.put(21, n5);
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sunGraphics2D.paint instanceof CColorPaint) {
            CColorPaint cColorPaint = (CColorPaint)sunGraphics2D.paint;
            long l = cColorPaint.getNSColor();
            if (this.fGraphicsStatesInt.get(19) != 1 || l != this.lastPaintPtr) {
                this.lastPaintPtr = l;
                this.fGraphicsStatesInt.put(19, 1);
                this.fGraphicsStatesLong.put(11, l);
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sunGraphics2D.paint instanceof Color) {
            Color color = (Color)sunGraphics2D.paint;
            int n6 = color.getRGB();
            if (this.fGraphicsStatesInt.get(19) != 0 || n6 != this.lastPaintRGB) {
                this.lastPaintRGB = n6;
                this.fGraphicsStatesInt.put(19, 0);
                this.fGraphicsStatesInt.put(20, n6);
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sunGraphics2D.paint instanceof GradientPaint) {
            if (this.fGraphicsStatesInt.get(19) != 3 || this.lastPaint != sunGraphics2D.paint) {
                GradientPaint gradientPaint = (GradientPaint)sunGraphics2D.paint;
                this.fGraphicsStatesInt.put(19, 3);
                this.fGraphicsStatesInt.put(24, gradientPaint.getColor1().getRGB());
                this.fGraphicsStatesInt.put(26, gradientPaint.getColor2().getRGB());
                this.fGraphicsStatesInt.put(28, gradientPaint.isCyclic() ? 1 : 0);
                Point2D point2D = gradientPaint.getPoint1();
                this.fGraphicsStatesFloat.put(29, (float)point2D.getX());
                this.fGraphicsStatesFloat.put(31, (float)point2D.getY());
                point2D = gradientPaint.getPoint2();
                this.fGraphicsStatesFloat.put(33, (float)point2D.getX());
                this.fGraphicsStatesFloat.put(35, (float)point2D.getY());
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (sunGraphics2D.paint instanceof TexturePaint) {
            if (this.fGraphicsStatesInt.get(19) != 4 || this.lastPaint != sunGraphics2D.paint) {
                TexturePaint texturePaint = (TexturePaint)sunGraphics2D.paint;
                this.fGraphicsStatesInt.put(19, 4);
                this.texturePaintImage = texturePaint.getImage();
                SurfaceData surfaceData = BufImgSurfaceData.createData(this.texturePaintImage);
                surfaceData.finishLazyDrawing();
                this.fGraphicsStatesInt.put(25, this.texturePaintImage.getWidth());
                this.fGraphicsStatesInt.put(27, this.texturePaintImage.getHeight());
                Rectangle2D rectangle2D = texturePaint.getAnchorRect();
                this.fGraphicsStatesFloat.put(30, (float)rectangle2D.getX());
                this.fGraphicsStatesFloat.put(32, (float)rectangle2D.getY());
                this.fGraphicsStatesFloat.put(34, (float)(rectangle2D.getWidth() / (double)this.texturePaintImage.getWidth()));
                this.fGraphicsStatesFloat.put(36, (float)(rectangle2D.getHeight() / (double)this.texturePaintImage.getHeight()));
                this.fGraphicsStatesObject[2] = surfaceData;
                this.fChangeFlag |= 8;
            } else {
                this.fChangeFlag &= 0xFFFFFFF7;
            }
        } else if (this.fGraphicsStatesInt.get(19) != 4 || this.lastPaint != sunGraphics2D.paint || (this.fChangeFlag & 1) != 0) {
            PaintContext paintContext = sunGraphics2D.paint.createContext(sunGraphics2D.getDeviceColorModel(), this.userBounds, this.userBounds, sIdentityMatrix, sunGraphics2D.hints);
            WritableRaster writableRaster = (WritableRaster)paintContext.getRaster(this.userBounds.x, this.userBounds.y, this.userBounds.width, this.userBounds.height);
            ColorModel colorModel = paintContext.getColorModel();
            this.texturePaintImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            this.fGraphicsStatesInt.put(19, 4);
            this.fGraphicsStatesInt.put(25, this.texturePaintImage.getWidth());
            this.fGraphicsStatesInt.put(27, this.texturePaintImage.getHeight());
            this.fGraphicsStatesFloat.put(30, (float)this.userBounds.getX());
            this.fGraphicsStatesFloat.put(32, (float)this.userBounds.getY());
            this.fGraphicsStatesFloat.put(34, 1.0f);
            this.fGraphicsStatesFloat.put(36, 1.0f);
            this.fGraphicsStatesObject[2] = BufImgSurfaceData.createData(this.texturePaintImage);
            paintContext.dispose();
            this.fChangeFlag |= 8;
        } else {
            this.fChangeFlag &= 0xFFFFFFF7;
        }
        this.lastPaint = sunGraphics2D.paint;
        this.seedPaint = sunGraphics2D.seedPaint;
    }

    void setupComposite(SunGraphics2D sunGraphics2D) {
        Composite composite = sunGraphics2D.composite;
        if (this.lastComposite != composite) {
            this.lastComposite = composite;
            int n = 3;
            float f = 1.0f;
            if (sunGraphics2D.compositeState <= 1 && composite != null) {
                AlphaComposite alphaComposite = (AlphaComposite)composite;
                n = alphaComposite.getRule();
                f = alphaComposite.getAlpha();
            }
            if (this.lastCompositeAlphaRule != n || this.lastCompositeAlphaValue != f) {
                this.fGraphicsStatesInt.put(37, n);
                this.fGraphicsStatesFloat.put(38, f);
                this.lastCompositeAlphaRule = n;
                this.lastCompositeAlphaValue = f;
                this.fChangeFlag |= 0x10;
            } else {
                this.fChangeFlag &= 0xFFFFFFEF;
            }
        } else {
            this.fChangeFlag &= 0xFFFFFFEF;
        }
        this.seedComposite = sunGraphics2D.seedComposite;
    }

    void setupStroke(SunGraphics2D sunGraphics2D) {
        BasicStroke basicStroke = defaultBasicStroke;
        if (sunGraphics2D.stroke instanceof BasicStroke) {
            basicStroke = (BasicStroke)sunGraphics2D.stroke;
        } else {
            System.err.println("Error: custom stroke not implemented");
            Thread.dumpStack();
        }
        if (this.lastStroke != basicStroke) {
            this.fGraphicsStatesObject[3] = basicStroke.getDashArray();
            this.fGraphicsStatesFloat.put(42, basicStroke.getDashPhase());
            this.fGraphicsStatesInt.put(40, basicStroke.getEndCap());
            this.fGraphicsStatesInt.put(39, basicStroke.getLineJoin());
            this.fGraphicsStatesFloat.put(41, basicStroke.getLineWidth());
            this.fGraphicsStatesFloat.put(43, basicStroke.getMiterLimit());
            this.fChangeFlag |= 0x20;
            this.lastStroke = basicStroke;
        } else {
            this.fChangeFlag &= 0xFFFFFFDF;
        }
        this.seedStroke = sunGraphics2D.seedStroke;
    }

    void setupFont(Font font, Paint paint) {
        if (font == null) {
            return;
        }
        if (font != this.lastFont || (this.fChangeFlag & 8) != 0) {
            this.fGraphicsStatesObject[4] = font;
            this.fGraphicsStatesObject[5] = paint;
            this.fChangeFlag |= 0x80;
            this.lastFont = font;
        } else {
            this.fChangeFlag &= 0xFFFFFF7F;
        }
    }

    void setupRenderingHints(SunGraphics2D sunGraphics2D) {
        boolean bl = false;
        int n = this.getAntialiasHint(sunGraphics2D);
        if (this.fGraphicsStatesInt.get(44) != n) {
            this.fGraphicsStatesInt.put(44, n);
            bl = true;
        }
        int n2 = this.getTextAntialiasHint(sunGraphics2D);
        if (this.fGraphicsStatesInt.get(45) != n2) {
            this.fGraphicsStatesInt.put(45, n2);
            bl = true;
        }
        int n3 = this.getFractionalMetricsHint(sunGraphics2D);
        if (this.fGraphicsStatesInt.get(46) != n3) {
            this.fGraphicsStatesInt.put(46, n3);
            bl = true;
        }
        int n4 = this.getRenderingHint(sunGraphics2D);
        if (this.fGraphicsStatesInt.get(47) != n4) {
            this.fGraphicsStatesInt.put(47, n4);
            bl = true;
        }
        int n5 = this.getInterpolationHint(sunGraphics2D);
        if (this.fGraphicsStatesInt.get(48) != n5) {
            this.fGraphicsStatesInt.put(48, n5);
            bl = true;
        }
        this.fChangeFlag = bl ? (this.fChangeFlag |= 0x40) : (this.fChangeFlag &= 0xFFFFFFBF);
        this.seedRenderingHints = sunGraphics2D.seedRenderingHints;
    }

    int getAntialiasHint(SunGraphics2D sunGraphics2D) {
        int n = sunGraphics2D.antialiasHint != 0 ? sunGraphics2D.antialiasHint : RuntimeOptions.getCurrentOptions().Antialiasing;
        return n;
    }

    int getTextAntialiasHint(SunGraphics2D sunGraphics2D) {
        int n = sunGraphics2D.textAntialiasHint != 0 ? sunGraphics2D.textAntialiasHint : (sunGraphics2D.antialiasHint != 0 ? (sunGraphics2D.antialiasHint == 2 ? 2 : 1) : RuntimeOptions.getCurrentOptions().TextAntialiasing);
        return n;
    }

    int getRenderingHint(SunGraphics2D sunGraphics2D) {
        int n = sunGraphics2D.renderHint != 0 ? sunGraphics2D.renderHint : RuntimeOptions.getCurrentOptions().Rendering;
        return n;
    }

    int getFractionalMetricsHint(SunGraphics2D sunGraphics2D) {
        int n = sunGraphics2D.fractionalMetricsHint != 0 ? sunGraphics2D.fractionalMetricsHint : RuntimeOptions.getCurrentOptions().FractionalMetrics;
        return n;
    }

    int getInterpolationHint(SunGraphics2D sunGraphics2D) {
        this.hintValue = sunGraphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        int n = this.hintValue != null ? ((SunHints.Value)this.hintValue).getIndex() : -1;
        int n2 = n != -1 ? n : RuntimeOptions.getCurrentOptions().Interpolation;
        return n2;
    }

    void setupGraphicsState(SunGraphics2D sunGraphics2D, int n) {
        this.setupGraphicsState(sunGraphics2D, n, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
    }

    void setupGraphicsState(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5) {
        this.setupGraphicsState(sunGraphics2D, n, sunGraphics2D.font, n2, n3, n4, n5);
    }

    void setupGraphicsState(SunGraphics2D sunGraphics2D, int n, Font font, int n2, int n3, int n4, int n5) {
        this.fChangeFlag = 0;
        if (this.lastSeedUserBounds != this.seedUserBounds) {
            this.setUserBounds(sunGraphics2D, n2, n3, n4, n5);
            this.lastSeedUserBounds = this.seedUserBounds;
        }
        Thread thread = Thread.currentThread();
        if (this.sg2dCurrent != sunGraphics2D || this.threadCurrent != thread) {
            this.finishLazyDrawing();
            this.sg2dCurrent = sunGraphics2D;
            this.threadCurrent = thread;
            this.seedBounds = 0;
            this.seedClip = 0;
            this.seedTransform = 0;
            this.seedPaint = 0;
            this.seedComposite = 0;
            this.seedStroke = 0;
            this.seedFont = 0;
            this.seedRenderingHints = 0;
            this.setupClip(sunGraphics2D);
            this.setupTransform(sunGraphics2D);
            this.setupPaint(sunGraphics2D, n2, n3, n4, n5);
            this.setupComposite(sunGraphics2D);
            this.setupStroke(sunGraphics2D);
            this.setupFont(font, sunGraphics2D.paint);
            this.setupRenderingHints(sunGraphics2D);
            this.fChangeFlag = -1;
        } else {
            int n6 = OSXSurfaceData.getRendererTypeForPrimitive(n);
            if (this.seedClip != sunGraphics2D.seedClip) {
                this.setupClip(sunGraphics2D);
            }
            if (this.seedTransform != sunGraphics2D.seedTransform) {
                this.setupTransform(sunGraphics2D);
            }
            if (n6 != 3) {
                if (this.seedComposite != sunGraphics2D.seedComposite) {
                    this.setupComposite(sunGraphics2D);
                }
                if (this.seedRenderingHints != sunGraphics2D.seedRenderingHints) {
                    this.setupRenderingHints(sunGraphics2D);
                }
                if (n6 != 1) {
                    if (this.seedPaint != sunGraphics2D.seedPaint) {
                        this.setupPaint(sunGraphics2D, n2, n3, n4, n5);
                    }
                    if (this.seedStroke != sunGraphics2D.seedStroke && n6 != 2) {
                        this.setupStroke(sunGraphics2D);
                    }
                    if (n6 != 0) {
                        this.setupFont(font, sunGraphics2D.paint);
                    }
                }
            }
        }
        this.fGraphicsStatesInt.put(0, this.fChangeFlag);
    }

    boolean isCustomPaint(SunGraphics2D sunGraphics2D) {
        return !(sunGraphics2D.paint instanceof Color) && !(sunGraphics2D.paint instanceof SystemColor) && !(sunGraphics2D.paint instanceof GradientPaint) && !(sunGraphics2D.paint instanceof CColorPaint) && !(sunGraphics2D.paint instanceof TexturePaint);
    }

    int getPathLength(GeneralPath generalPath) {
        int n = 0;
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            pathIterator.next();
            ++n;
        }
        return n;
    }

    int getPathCoordinates(GeneralPath generalPath, FloatBuffer floatBuffer, IntBuffer intBuffer) {
        floatBuffer.clear();
        intBuffer.clear();
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(this.segmentCoordinatesArray);
            switch (n) {
                case 0: {
                    floatBuffer.put(this.segmentCoordinatesArray[0]);
                    floatBuffer.put(this.segmentCoordinatesArray[1]);
                    break;
                }
                case 1: {
                    floatBuffer.put(this.segmentCoordinatesArray[0]);
                    floatBuffer.put(this.segmentCoordinatesArray[1]);
                    break;
                }
                case 2: {
                    floatBuffer.put(this.segmentCoordinatesArray[0]);
                    floatBuffer.put(this.segmentCoordinatesArray[1]);
                    floatBuffer.put(this.segmentCoordinatesArray[2]);
                    floatBuffer.put(this.segmentCoordinatesArray[3]);
                    break;
                }
                case 3: {
                    floatBuffer.put(this.segmentCoordinatesArray[0]);
                    floatBuffer.put(this.segmentCoordinatesArray[1]);
                    floatBuffer.put(this.segmentCoordinatesArray[2]);
                    floatBuffer.put(this.segmentCoordinatesArray[3]);
                    floatBuffer.put(this.segmentCoordinatesArray[4]);
                    floatBuffer.put(this.segmentCoordinatesArray[5]);
                    break;
                }
            }
            intBuffer.put(n);
            pathIterator.next();
        }
        return pathIterator.getWindingRule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLine(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.setupGraphicsState(sunGraphics2D, 5, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
            if (!this.fDrawingQueue.addLine(f, f2, f3, f4)) {
                cRenderer.doLine(this, f, f2, f3, f4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRect(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, boolean bl) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                ++this.seedUserBounds;
                ++sunGraphics2D.seedPaint;
                this.setupGraphicsState(sunGraphics2D, 6, (int)f, (int)f2, (int)f3, (int)f4);
            } else {
                this.setupGraphicsState(sunGraphics2D, 6, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
            }
            if (!this.fDrawingQueue.addRect(f, f2, f3, f4, bl)) {
                cRenderer.doRect(this, f, f2, f3, f4, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRoundRect(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                ++this.seedUserBounds;
                ++sunGraphics2D.seedPaint;
                this.setupGraphicsState(sunGraphics2D, 7, (int)f, (int)f2, (int)f3, (int)f4);
            } else {
                this.setupGraphicsState(sunGraphics2D, 7, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
            }
            if (!this.fDrawingQueue.addRoundRect(f, f2, f3, f4, f5, f6, bl)) {
                cRenderer.doRoundRect(this, f, f2, f3, f4, f5, f6, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOval(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, boolean bl) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                ++this.seedUserBounds;
                ++sunGraphics2D.seedPaint;
                this.setupGraphicsState(sunGraphics2D, 8, (int)f, (int)f2, (int)f3, (int)f4);
            } else {
                this.setupGraphicsState(sunGraphics2D, 8, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
            }
            if (!this.fDrawingQueue.addOval(f, f2, f3, f4, bl)) {
                cRenderer.doOval(this, f, f2, f3, f4, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doArc(CRenderer cRenderer, SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6, int n, boolean bl) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                ++this.seedUserBounds;
                ++sunGraphics2D.seedPaint;
                this.setupGraphicsState(sunGraphics2D, 9, (int)f, (int)f2, (int)f3, (int)f4);
            } else {
                this.setupGraphicsState(sunGraphics2D, 9, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
            }
            if (!this.fDrawingQueue.addArc(f, f2, f3, f4, f5, f6, n, bl)) {
                cRenderer.doArc(this, f, f2, f3, f4, f5, f6, n, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPolygon(CRenderer cRenderer, SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            if (bl2 && this.isCustomPaint(sunGraphics2D)) {
                ++this.seedUserBounds;
                ++sunGraphics2D.seedPaint;
                int n2 = nArray[0];
                int n3 = nArray2[0];
                int n4 = n2;
                int n5 = n3;
                for (int i = 1; i < n; ++i) {
                    int n6 = nArray[i];
                    if (n6 < n2) {
                        n2 = n6;
                    } else if (n6 > n4) {
                        n4 = n6;
                    }
                    int n7 = nArray2[i];
                    if (n7 < n3) {
                        n3 = n7;
                        continue;
                    }
                    if (n7 <= n5) continue;
                    n5 = n7;
                }
                this.setupGraphicsState(sunGraphics2D, 10, n2, n3, n4 - n2, n5 - n3);
            } else {
                this.setupGraphicsState(sunGraphics2D, 10, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
            }
            cRenderer.doPoly(this, nArray, nArray2, n, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawfillShape(CRenderer cRenderer, SunGraphics2D sunGraphics2D, GeneralPath generalPath, boolean bl, boolean bl2) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            if (bl && this.isCustomPaint(sunGraphics2D)) {
                ++this.seedUserBounds;
                ++sunGraphics2D.seedPaint;
                Rectangle rectangle = generalPath.getBounds();
                this.setupGraphicsState(sunGraphics2D, 11, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                this.setupGraphicsState(sunGraphics2D, 11, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
            }
            int n = this.getPathLength(generalPath);
            if (this.shapeCoordinatesArray == null || this.shapeCoordinatesArray.capacity() < n * 6) {
                this.shapeCoordinatesArray = OSXSurfaceData.getBufferOfSize(n * 6).asFloatBuffer();
            }
            if (this.shapeTypesArray == null || this.shapeTypesArray.capacity() < n) {
                this.shapeTypesArray = OSXSurfaceData.getBufferOfSize(n).asIntBuffer();
            }
            int n2 = this.getPathCoordinates(generalPath, this.shapeCoordinatesArray, this.shapeTypesArray);
            cRenderer.doShape(this, n, this.shapeCoordinatesArray, this.shapeTypesArray, n2, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blitImage(CRenderer cRenderer, SunGraphics2D sunGraphics2D, SurfaceData surfaceData, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        Object object = this.getLockObject();
        synchronized (object) {
            OSXOffScreenSurfaceData oSXOffScreenSurfaceData = (OSXOffScreenSurfaceData)surfaceData;
            Object object2 = oSXOffScreenSurfaceData.getLockObject();
            synchronized (object2) {
                int n9 = oSXOffScreenSurfaceData.bim.getWidth();
                int n10 = oSXOffScreenSurfaceData.bim.getHeight();
                oSXOffScreenSurfaceData.finishLazyDrawing();
                this.setupGraphicsState(sunGraphics2D, 1, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
                if (color != null) {
                    surfaceData = oSXOffScreenSurfaceData.getCopyWithBgColor(color);
                }
                if (!this.fDrawingQueue.addImage(surfaceData, bl, bl2, n9, n10, n, n2, n3, n4, n5, n6, n7, n8)) {
                    cRenderer.doImage(this, surfaceData, bl, bl2, n9, n10, n, n2, n3, n4, n5, n6, n7, n8);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupCocoaDrawing(SunGraphics2D sunGraphics2D) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            this.setupGraphicsState(sunGraphics2D, 4, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(CTextPipe cTextPipe, SunGraphics2D sunGraphics2D, String string, double d, double d2) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (string.length() == 0) {
                return;
            }
            this.finishLazyDrawing();
            this.setupGraphicsState(sunGraphics2D, 13, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
            cTextPipe.doDrawString(this, string, d, d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawGlyphs(CTextPipe cTextPipe, SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            this.setupGraphicsState(sunGraphics2D, 14, glyphVector.getFont(), 0, 0, this.fBounds.width, this.fBounds.height);
            cTextPipe.doDrawGlyphs(this, glyphVector, f, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawUnicodes(CTextPipe cTextPipe, SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, float f, float f2) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            this.setupGraphicsState(sunGraphics2D, 15, sunGraphics2D.font, 0, 0, this.fBounds.width, this.fBounds.height);
            if (n2 == 1) {
                cTextPipe.doOneUnicode(this, cArray[n], f, f2);
            } else {
                cTextPipe.doUnicodes(this, cArray, n, n2, f, f2);
            }
        }
    }

    void intersection(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        long l = n + rectangle.width;
        long l2 = n2 + rectangle.height;
        int n3 = rectangle2.x;
        int n4 = rectangle2.y;
        long l3 = n3 + rectangle2.width;
        long l4 = n4 + rectangle2.height;
        if (n < n3) {
            n = n3;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        if (l > l3) {
            l = l3;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        l2 -= (long)n2;
        if ((l -= (long)n) < Integer.MIN_VALUE) {
            l = Integer.MIN_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        rectangle3.setBounds(n, n2, (int)l, (int)l2);
    }

    protected Rectangle clipCopyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyAreaBounds.setBounds(sunGraphics2D.devClip.getLoX(), sunGraphics2D.devClip.getLoY(), sunGraphics2D.devClip.getWidth(), sunGraphics2D.devClip.getHeight());
        this.srcCopyAreaRect.setBounds(n += sunGraphics2D.transX, n2 += sunGraphics2D.transY, n3, n4);
        this.intersection(this.srcCopyAreaRect, this.copyAreaBounds, this.srcCopyAreaRect);
        if (this.srcCopyAreaRect.width <= 0 || this.srcCopyAreaRect.height <= 0) {
            return null;
        }
        this.dstCopyAreaRect.setBounds(this.srcCopyAreaRect.x + n5, this.srcCopyAreaRect.y + n6, this.srcCopyAreaRect.width, this.srcCopyAreaRect.height);
        this.intersection(this.dstCopyAreaRect, this.copyAreaBounds, this.dstCopyAreaRect);
        if (this.dstCopyAreaRect.width <= 0 || this.dstCopyAreaRect.height <= 0) {
            return null;
        }
        n = this.dstCopyAreaRect.x - n5;
        n2 = this.dstCopyAreaRect.y - n6;
        n3 = this.dstCopyAreaRect.width;
        n4 = this.dstCopyAreaRect.height;
        this.finalCopyAreaRect.setBounds(n, n2, n3, n4);
        return this.finalCopyAreaRect;
    }

    protected void markDirty(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLazyDrawing() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.markDirty(false);
            this.fDrawingQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLazyDrawing() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.fDrawingQueue.finish();
            this.markDirty(false);
        }
    }

    public void disableLazyDrawing() {
        this.finishLazyDrawing();
        this.fDrawingQueue.disableLazyDrawing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishLazyDrawing(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, Object[] objectArray, int n2) {
        Object object = this.getLockObject();
        synchronized (object) {
            this._finishLazyDrawing(byteBuffer, byteBuffer2, n, objectArray, n2);
        }
    }

    native void _finishLazyDrawing(ByteBuffer var1, ByteBuffer var2, int var3, Object[] var4, int var5);

    private void clearObjectParameters(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
    }

    static ByteBuffer getBufferOfSize(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static boolean IsSimpleColor(Object object) {
        return object instanceof Color || object instanceof SystemColor || object instanceof ColorUIResource || object instanceof CColorPaint;
    }

    static {
        RuntimeOptions runtimeOptions = RuntimeOptions.getCurrentOptions();
        OSXSurfaceData.init(runtimeOptions.AdjustForJavaDrawing, runtimeOptions.EnableQ2DX);
        sIdentityMatrix = new AffineTransform();
        defaultBasicStroke = new BasicStroke();
        runtimeOptions = RuntimeOptions.getCurrentOptions();
        kMinQueueSize = 2;
        kQueueSizeMultiplier = 5;
        kMaxQueueSize = RuntimeOptions.EnableLazyDrawingQueueSizeMax;
        kQueueSizeGrowFlush = RuntimeOptions.EnableLazyDrawingQueueSizeGrowFlush;
    }

    class DrawingQueue {
        boolean fQueueGraphicsPrimitives;
        ByteBuffer fGraphicsStatesCopy;
        IntBuffer fGraphicsStatesIntCopy;
        FloatBuffer fGraphicsStatesFloatCopy;
        LongBuffer fGraphicsStatesLongCopy;
        Object[] fGraphicsStatesObjectCopy;
        int fMaxQueueEntryCount;
        ByteBuffer fQueue;
        int fQueueIndex;
        IntBuffer fIntQueue;
        FloatBuffer fFloatQueue;
        LongBuffer fLongQueue;
        Object[] fObjectQueue;
        int fObjectQueueIndex;
        int fDontcareFlags;

        public DrawingQueue() {
            this.fQueueGraphicsPrimitives = RuntimeOptions.getCurrentOptions().EnableLazyDrawing;
            this.fGraphicsStatesCopy = OSXSurfaceData.getBufferOfSize(50);
            this.fGraphicsStatesIntCopy = this.fGraphicsStatesCopy.asIntBuffer();
            this.fGraphicsStatesFloatCopy = this.fGraphicsStatesCopy.asFloatBuffer();
            this.fGraphicsStatesLongCopy = this.fGraphicsStatesCopy.asLongBuffer();
            this.fGraphicsStatesObjectCopy = null;
            this.fDontcareFlags = -10;
            this.fQueueIndex = 0;
            this.fObjectQueueIndex = 0;
            this.fMaxQueueEntryCount = 10;
            if (10 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 10;
            }
            if (11 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 11;
            }
            if (13 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 13;
            }
            if (11 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 11;
            }
            if (14 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 14;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (22 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 22;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
            if (0 > this.fMaxQueueEntryCount) {
                this.fMaxQueueEntryCount = 0;
            }
        }

        void disableLazyDrawing() {
            this.fQueueGraphicsPrimitives = false;
        }

        boolean addLine(float f, float f2, float f3, float f4) {
            if (!this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n = 5;
            if (this.canThisRendererBeQueued(OSXSurfaceData.getRendererTypeForPrimitive(n))) {
                this.init(n);
                this.addCommonInfo(n);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                return true;
            }
            this.finish();
            return false;
        }

        boolean addRect(float f, float f2, float f3, float f4, boolean bl) {
            if (!this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n = 6;
            if (this.canThisRendererBeQueued(OSXSurfaceData.getRendererTypeForPrimitive(n))) {
                this.init(n);
                this.addCommonInfo(n);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                return true;
            }
            this.finish();
            return false;
        }

        boolean addRoundRect(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
            if (!this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n = 7;
            if (this.canThisRendererBeQueued(OSXSurfaceData.getRendererTypeForPrimitive(n))) {
                this.init(n);
                this.addCommonInfo(n);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                this.fFloatQueue.put(this.fQueueIndex++, f5);
                this.fFloatQueue.put(this.fQueueIndex++, f6);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                return true;
            }
            this.finish();
            return false;
        }

        boolean addOval(float f, float f2, float f3, float f4, boolean bl) {
            if (!this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n = 8;
            if (this.canThisRendererBeQueued(OSXSurfaceData.getRendererTypeForPrimitive(n))) {
                this.init(n);
                this.addCommonInfo(n);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                return true;
            }
            this.finish();
            return false;
        }

        boolean addArc(float f, float f2, float f3, float f4, float f5, float f6, int n, boolean bl) {
            if (!this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n2 = 9;
            if (this.canThisRendererBeQueued(OSXSurfaceData.getRendererTypeForPrimitive(n2))) {
                this.init(n2);
                this.addCommonInfo(n2);
                this.fFloatQueue.put(this.fQueueIndex++, f);
                this.fFloatQueue.put(this.fQueueIndex++, f2);
                this.fFloatQueue.put(this.fQueueIndex++, f3);
                this.fFloatQueue.put(this.fQueueIndex++, f4);
                this.fFloatQueue.put(this.fQueueIndex++, f5);
                this.fFloatQueue.put(this.fQueueIndex++, f6);
                this.fIntQueue.put(this.fQueueIndex++, n);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                return true;
            }
            this.finish();
            return false;
        }

        boolean addImage(SurfaceData surfaceData, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
            if (!this.fQueueGraphicsPrimitives) {
                return false;
            }
            int n11 = 1;
            boolean bl3 = false;
            if (surfaceData instanceof OSXOffScreenSurfaceData) {
                bl3 = ((OSXOffScreenSurfaceData)surfaceData).isImageConstant();
            }
            if (bl3 && this.canThisRendererBeQueued(OSXSurfaceData.getRendererTypeForPrimitive(n11))) {
                this.init(n11);
                this.addCommonInfo(n11);
                this.fIntQueue.put(this.fQueueIndex++, bl ? 1 : 0);
                this.fIntQueue.put(this.fQueueIndex++, bl2 ? 1 : 0);
                this.fFloatQueue.put(this.fQueueIndex++, n);
                this.fFloatQueue.put(this.fQueueIndex++, n2);
                this.fFloatQueue.put(this.fQueueIndex++, n3);
                this.fFloatQueue.put(this.fQueueIndex++, n4);
                this.fFloatQueue.put(this.fQueueIndex++, n5);
                this.fFloatQueue.put(this.fQueueIndex++, n6);
                this.fFloatQueue.put(this.fQueueIndex++, n7);
                this.fFloatQueue.put(this.fQueueIndex++, n8);
                this.fFloatQueue.put(this.fQueueIndex++, n9);
                this.fFloatQueue.put(this.fQueueIndex++, n10);
                this.fObjectQueue[this.fObjectQueueIndex++] = surfaceData;
                return true;
            }
            this.finish();
            return false;
        }

        void addCommonInfo(int n) {
            IntBuffer intBuffer = OSXSurfaceData.this.fGraphicsStatesInt;
            boolean bl = this.fQueueIndex == 0;
            boolean bl2 = (OSXSurfaceData.this.fChangeFlag & 8) != 0;
            boolean bl3 = bl2 || bl;
            this.fIntQueue.put(this.fQueueIndex++, n);
            if (bl3) {
                this.fIntQueue.put(this.fQueueIndex++, 1);
                int n2 = intBuffer.get(19);
                this.fIntQueue.put(this.fQueueIndex++, n2);
                switch (n2) {
                    case 0: {
                        this.fIntQueue.put(this.fQueueIndex, OSXSurfaceData.this.lastPaintRGB);
                        ++this.fQueueIndex;
                        break;
                    }
                    case 1: {
                        if (this.fQueueIndex % 2 != 0) {
                            this.fIntQueue.put(this.fQueueIndex++, 0);
                        }
                        this.fLongQueue.put(this.fQueueIndex / 2, OSXSurfaceData.this.lastPaintPtr);
                        this.fQueueIndex += 2;
                        break;
                    }
                    case 2: {
                        this.fIntQueue.put(this.fQueueIndex, OSXSurfaceData.this.lastPaintIndex);
                        ++this.fQueueIndex;
                        break;
                    }
                    default: {
                        System.err.println("unknown color state=" + n2);
                        Thread.dumpStack();
                        break;
                    }
                }
            } else {
                this.fIntQueue.put(this.fQueueIndex++, 0);
            }
        }

        boolean canThisRendererBeQueued(int n) {
            boolean bl = false;
            switch (n) {
                case 0: 
                case 1: {
                    int n2;
                    IntBuffer intBuffer = OSXSurfaceData.this.fGraphicsStatesInt;
                    if ((OSXSurfaceData.this.fChangeFlag & this.fDontcareFlags) != 0 || (n2 = intBuffer.get(19)) != 0 && n2 != 2 && n2 != 1) break;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        void init(int n) {
            boolean bl;
            if (this.fQueue == null) {
                this.fQueue = OSXSurfaceData.getBufferOfSize(kMinQueueSize * this.fMaxQueueEntryCount);
                this.fIntQueue = this.fQueue.asIntBuffer();
                this.fFloatQueue = this.fQueue.asFloatBuffer();
                this.fLongQueue = this.fQueue.asLongBuffer();
                this.fObjectQueue = new Object[kMinQueueSize];
            } else {
                this.assureQueueHasEnoughRoom(n);
            }
            boolean bl2 = bl = this.fQueueIndex == 0;
            if (bl) {
                this.fGraphicsStatesCopy.rewind();
                OSXSurfaceData.this.fGraphicsStates.rewind();
                this.fGraphicsStatesCopy.put(OSXSurfaceData.this.fGraphicsStates);
                this.fGraphicsStatesCopy.rewind();
                OSXSurfaceData.this.fGraphicsStates.rewind();
            }
        }

        void assureQueueHasEnoughRoom(int n) {
            if (!this.canThisPrimitiveFitInQueue(n)) {
                if (this.fIntQueue.capacity() < kMaxQueueSize) {
                    int n2 = this.fQueue.capacity() / 4 * kQueueSizeMultiplier;
                    ByteBuffer byteBuffer = OSXSurfaceData.getBufferOfSize(n2);
                    IntBuffer intBuffer = byteBuffer.asIntBuffer();
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    LongBuffer longBuffer = byteBuffer.asLongBuffer();
                    Object[] objectArray = new Object[n2 / this.fMaxQueueEntryCount];
                    if (this.fIntQueue.capacity() >= kQueueSizeGrowFlush) {
                        this.finish();
                    } else {
                        int n3;
                        for (n3 = 0; n3 < this.fQueueIndex; ++n3) {
                            intBuffer.put(n3, this.fIntQueue.get(n3));
                        }
                        for (n3 = 0; n3 < this.fObjectQueue.length; ++n3) {
                            objectArray[n3] = this.fObjectQueue[n3];
                        }
                    }
                    this.fQueue = byteBuffer;
                    this.fIntQueue = intBuffer;
                    this.fFloatQueue = floatBuffer;
                    this.fLongQueue = longBuffer;
                    this.fObjectQueue = objectArray;
                } else {
                    this.finish();
                }
            }
        }

        boolean canThisPrimitiveFitInQueue(int n) {
            boolean bl = false;
            int n2 = this.fIntQueue.capacity() - this.fQueueIndex;
            switch (n) {
                case 5: {
                    bl = n2 >= 10;
                    break;
                }
                case 6: {
                    bl = n2 >= 11;
                    break;
                }
                case 7: {
                    bl = n2 >= 13;
                    break;
                }
                case 8: {
                    bl = n2 >= 11;
                    break;
                }
                case 9: {
                    bl = n2 >= 14;
                    break;
                }
                case 1: {
                    bl = n2 >= 22;
                    bl = bl && this.fObjectQueueIndex < this.fObjectQueue.length;
                    break;
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finish() {
            Object object = OSXSurfaceData.this.getLockObject();
            synchronized (object) {
                if (this.fQueueGraphicsPrimitives && this.fQueue != null) {
                    if (this.fQueueIndex > 0) {
                        try {
                            OSXSurfaceData.this.finishLazyDrawing(this.fGraphicsStatesCopy, this.fQueue, this.fQueueIndex, this.fObjectQueue, this.fObjectQueueIndex);
                        }
                        catch (InvalidPipeException invalidPipeException) {
                            Thread.dumpStack();
                        }
                    }
                    this.fQueueIndex = 0;
                    this.fObjectQueueIndex = 0;
                    this.fQueue.clear();
                    this.fIntQueue.clear();
                    this.fFloatQueue.clear();
                    this.fLongQueue.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            Object object = OSXSurfaceData.this.getLockObject();
            synchronized (object) {
                if (this.fQueueGraphicsPrimitives && this.fQueue != null) {
                    this.fQueueIndex = 0;
                    this.fObjectQueueIndex = 0;
                    this.fQueue.clear();
                    this.fIntQueue.clear();
                    this.fFloatQueue.clear();
                    this.fLongQueue.clear();
                }
            }
        }
    }
}

