/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.IntegerNIORaster;
import apple.awt.RuntimeOptions;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.RasterListener;
import sun.awt.image.ShortComponentRaster;
import sun.awt.image.SunWritableRaster;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;

public class OSXOffScreenSurfaceData
extends BufImgSurfaceData
implements RasterListener {
    BufferedImage bim;
    BufferedImage bimBackup;
    static DirectColorModel dcmBackup;
    Object lock;
    WritableRaster bufImgRaster;
    SunWritableRaster bufImgSunRaster;
    private static final int TYPE_3BYTE_RGB = 14;
    private static final int TYPE_NATIVEIO = 15;
    protected ByteBuffer fImageInfo = ByteBuffer.allocateDirect(20);
    IntBuffer fImageInfoInt;
    private static final int kNeedToSyncFromJavaPixelsIndex = 0;
    private static final int kNativePixelsChangedIndex = 1;
    private static final int kImageIsSrcOnlyIndex = 2;
    private static final int kImageIsConstantIndex = 3;
    private static final int kImageStolenIndex = 4;
    private static final int kSizeOfParameters = 5;
    public static final String DESC_INT_ARGB_PRE_Q = "Integer ARGB_PRE 32 bit Display Quartz";
    public static final SurfaceType IntArgbPreQ;
    private static boolean gUseLazyPixelConversion;
    BufferedImage copyWithBgColor_cache = null;

    private static native void initIDs();

    public static native SurfaceData getSurfaceData(BufferedImage var0);

    protected static native void setSurfaceData(BufferedImage var0, SurfaceData var1);

    public static SurfaceData createData(BufferedImage bufferedImage) {
        SurfaceData surfaceData = OSXOffScreenSurfaceData.getSurfaceData(bufferedImage);
        if (surfaceData != null) {
            return surfaceData;
        }
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = OSXOffScreenSurfaceData.createNewSurface(bufferedImage);
        OSXOffScreenSurfaceData.setSurfaceData(bufferedImage, oSXOffScreenSurfaceData);
        if (fRenderer == 1) {
            oSXOffScreenSurfaceData.cacheRasters(bufferedImage);
            oSXOffScreenSurfaceData.setRasterListener();
        } else {
            oSXOffScreenSurfaceData.initSolidLoops();
            oSXOffScreenSurfaceData.disableLazyDrawing();
            oSXOffScreenSurfaceData.rasterStolen();
        }
        return oSXOffScreenSurfaceData;
    }

    private static OSXOffScreenSurfaceData createNewSurface(BufferedImage bufferedImage) {
        Object object;
        Object object2;
        SurfaceData surfaceData = null;
        ColorModel colorModel = bufferedImage.getColorModel();
        int n = bufferedImage.getType();
        switch (n) {
            case 4: {
                surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, SurfaceType.IntBgr);
                break;
            }
            case 1: {
                surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, SurfaceType.IntRgb);
                break;
            }
            case 2: {
                surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, SurfaceType.IntArgb);
                break;
            }
            case 3: {
                surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, SurfaceType.IntArgbPre);
                break;
            }
            case 5: {
                surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, SurfaceType.ThreeByteBgr, 2);
                break;
            }
            case 6: {
                surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, SurfaceType.FourByteAbgr, 3);
                break;
            }
            case 7: {
                surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, SurfaceType.FourByteAbgrPre, 3);
                break;
            }
            case 8: {
                surfaceData = OSXOffScreenSurfaceData.createDataSC(bufferedImage, SurfaceType.Ushort565Rgb, null);
                break;
            }
            case 9: {
                surfaceData = OSXOffScreenSurfaceData.createDataSC(bufferedImage, SurfaceType.Ushort555Rgb, null);
                break;
            }
            case 13: {
                switch (colorModel.getTransparency()) {
                    case 1: {
                        if (OSXOffScreenSurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                            object2 = SurfaceType.Index8Gray;
                            break;
                        }
                        object2 = SurfaceType.ByteIndexedOpaque;
                        break;
                    }
                    case 2: {
                        object2 = SurfaceType.ByteIndexedBm;
                        break;
                    }
                    case 3: {
                        object2 = SurfaceType.ByteIndexed;
                        break;
                    }
                    default: {
                        throw new InternalError("Unrecognized transparency");
                    }
                }
                surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, (SurfaceType)object2, 0);
                break;
            }
            case 10: {
                surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, SurfaceType.ByteGray, 0);
                break;
            }
            case 11: {
                surfaceData = OSXOffScreenSurfaceData.createDataSC(bufferedImage, SurfaceType.UshortGray, null);
                break;
            }
            default: {
                boolean bl;
                object2 = bufferedImage.getRaster();
                object = bufferedImage.getSampleModel();
                SurfaceType surfaceType = SurfaceType.Custom;
                int n2 = colorModel.getTransferType();
                int n3 = colorModel.getPixelSize();
                int n4 = colorModel.getNumColorComponents();
                if (n4 != 3 || !(colorModel instanceof ComponentColorModel) || !(object instanceof PixelInterleavedSampleModel)) break;
                int[] nArray = colorModel.getComponentSize();
                boolean bl2 = nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8;
                int[] nArray2 = ((ComponentSampleModel)object).getBandOffsets();
                int n5 = ((Raster)object2).getNumBands();
                boolean bl3 = nArray2[0] == n5 - 3 && nArray2[1] == n5 - 2 && nArray2[2] == n5 - 1;
                boolean bl4 = bl = nArray2[0] == n5 - 1 && nArray2[1] == n5 - 2 && nArray2[2] == n5 - 3;
                if (n3 == 32 && n2 == 3) {
                    if (bl2 && bl3 && colorModel.hasAlpha() && colorModel.isAlphaPremultiplied() && nArray[3] == 8) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, surfaceType, 3);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (bl2 && bl3 && colorModel.hasAlpha() && nArray[3] == 8) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, surfaceType, 2);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (bl2 && bl && colorModel.hasAlpha() && colorModel.isAlphaPremultiplied() && nArray[3] == 8) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, surfaceType, 7);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (bl2 && bl && colorModel.hasAlpha() && nArray[3] == 8) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, surfaceType, 6);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (!bl2 || !bl3) break;
                    try {
                        surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, surfaceType, 1);
                    }
                    catch (ClassCastException classCastException) {
                        surfaceData = null;
                    }
                    break;
                }
                if (n3 == 32 && n2 == 0) {
                    if (bl2 && bl3 && colorModel.hasAlpha() && colorModel.isAlphaPremultiplied() && nArray[3] == 8) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 3, 3);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                    }
                    if (bl2 && bl3 && colorModel.hasAlpha() && nArray[3] == 8) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 3, 2);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (bl2 && bl && colorModel.hasAlpha() && colorModel.isAlphaPremultiplied() && nArray[3] == 8) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 3, 7);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (bl2 && bl && colorModel.hasAlpha() && nArray[3] == 8) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 3, 6);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (bl2 && bl) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 3, 4);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (!bl2 || !bl3) break;
                    try {
                        surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 3, 1);
                    }
                    catch (ClassCastException classCastException) {
                        surfaceData = null;
                    }
                    break;
                }
                if (n3 == 24 && n2 == 3) {
                    if (bl2 && bl3) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, surfaceType, 1);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (!bl2 || !bl) break;
                    try {
                        surfaceData = OSXOffScreenSurfaceData.createDataIC(bufferedImage, surfaceType, 4);
                    }
                    catch (ClassCastException classCastException) {
                        surfaceData = null;
                    }
                    break;
                }
                if (n3 == 24 && n2 == 0) {
                    if (bl2 && bl3) {
                        try {
                            surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 0, 14);
                        }
                        catch (ClassCastException classCastException) {
                            surfaceData = null;
                        }
                        break;
                    }
                    if (!bl2 || !bl) break;
                    try {
                        surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 0, 5);
                    }
                    catch (ClassCastException classCastException) {
                        surfaceData = null;
                    }
                    break;
                }
                if (n3 == 16 && n2 == 1) {
                    boolean bl5 = bl2 = nArray[0] == 5 && nArray[1] == 6 && nArray[2] == 5;
                    if (!bl2 || !bl3) break;
                    try {
                        surfaceData = OSXOffScreenSurfaceData.createDataSC(bufferedImage, surfaceType, null, 8);
                    }
                    catch (ClassCastException classCastException) {
                        surfaceData = null;
                    }
                    break;
                }
                if (n3 == 16 && n2 == 0) {
                    boolean bl6 = bl2 = nArray[0] == 5 && nArray[1] == 6 && nArray[2] == 5;
                    if (!bl2 || !bl3) break;
                    try {
                        surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 1, 8);
                    }
                    catch (ClassCastException classCastException) {
                        surfaceData = null;
                    }
                    break;
                }
                if (n3 == 15 && n2 == 1) {
                    boolean bl7 = bl2 = nArray[0] == 5 && nArray[1] == 5 && nArray[2] == 5;
                    if (!bl2 || !bl3) break;
                    try {
                        surfaceData = OSXOffScreenSurfaceData.createDataSC(bufferedImage, surfaceType, null, 9);
                    }
                    catch (ClassCastException classCastException) {
                        surfaceData = null;
                    }
                    break;
                }
                if (n3 != 15 || n2 != 0) break;
                boolean bl8 = bl2 = nArray[0] == 5 && nArray[1] == 5 && nArray[2] == 5;
                if (!bl2 || !bl3) break;
                try {
                    surfaceData = OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, 1, 9);
                    break;
                }
                catch (ClassCastException classCastException) {
                    surfaceData = null;
                }
            }
        }
        if (surfaceData == null) {
            surfaceData = new OSXOffScreenSurfaceData(bufferedImage, SurfaceType.Custom);
            object2 = (OSXOffScreenSurfaceData)surfaceData;
            object = (IntegerNIORaster)IntegerNIORaster.createNIORaster(bufferedImage.getWidth(), bufferedImage.getHeight(), dcmBackup.getMasks(), null);
            ((OSXOffScreenSurfaceData)object2).bimBackup = new BufferedImage(dcmBackup, (WritableRaster)object, dcmBackup.isAlphaPremultiplied(), null);
            ((OSXOffScreenSurfaceData)object2).initCustomRaster(((IntegerNIORaster)object).getBuffer(), ((Raster)object).getWidth(), ((Raster)object).getHeight(), ((OSXOffScreenSurfaceData)object2).fGraphicsStates, ((OSXOffScreenSurfaceData)object2).fGraphicsStatesObject, ((OSXOffScreenSurfaceData)object2).fImageInfo);
            ((OSXOffScreenSurfaceData)object2).checkIfLazyPixelConversionDisabled();
        }
        return (OSXOffScreenSurfaceData)surfaceData;
    }

    public static SurfaceData createData(Raster raster, ColorModel colorModel) {
        throw new InternalError("SurfaceData not implemented for Raster/CM");
    }

    private static SurfaceData createDataIC(BufferedImage bufferedImage, SurfaceType surfaceType, int n) {
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = new OSXOffScreenSurfaceData(bufferedImage, surfaceType);
        IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
        oSXOffScreenSurfaceData.initRaster(integerComponentRaster.getDataStorage(), integerComponentRaster.getDataOffset(0) * 4, integerComponentRaster.getWidth(), integerComponentRaster.getHeight(), integerComponentRaster.getPixelStride() * 4, integerComponentRaster.getScanlineStride() * 4, null, n, oSXOffScreenSurfaceData.fGraphicsStates, oSXOffScreenSurfaceData.fGraphicsStatesObject, oSXOffScreenSurfaceData.fImageInfo);
        oSXOffScreenSurfaceData.checkIfLazyPixelConversionDisabled();
        return oSXOffScreenSurfaceData;
    }

    public static SurfaceData createDataIC(BufferedImage bufferedImage, SurfaceType surfaceType) {
        return OSXOffScreenSurfaceData.createDataIC(bufferedImage, surfaceType, bufferedImage.getType());
    }

    private static SurfaceData createDataSC(BufferedImage bufferedImage, SurfaceType surfaceType, IndexColorModel indexColorModel, int n) {
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = new OSXOffScreenSurfaceData(bufferedImage, surfaceType);
        ShortComponentRaster shortComponentRaster = (ShortComponentRaster)bufferedImage.getRaster();
        oSXOffScreenSurfaceData.initRaster(shortComponentRaster.getDataStorage(), shortComponentRaster.getDataOffset(0) * 2, shortComponentRaster.getWidth(), shortComponentRaster.getHeight(), shortComponentRaster.getPixelStride() * 2, shortComponentRaster.getScanlineStride() * 2, indexColorModel, n, oSXOffScreenSurfaceData.fGraphicsStates, oSXOffScreenSurfaceData.fGraphicsStatesObject, oSXOffScreenSurfaceData.fImageInfo);
        oSXOffScreenSurfaceData.checkIfLazyPixelConversionDisabled();
        return oSXOffScreenSurfaceData;
    }

    public static SurfaceData createDataSC(BufferedImage bufferedImage, SurfaceType surfaceType, IndexColorModel indexColorModel) {
        return OSXOffScreenSurfaceData.createDataSC(bufferedImage, surfaceType, indexColorModel, bufferedImage.getType());
    }

    private static SurfaceData createDataBC(BufferedImage bufferedImage, SurfaceType surfaceType, int n, int n2) {
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = new OSXOffScreenSurfaceData(bufferedImage, surfaceType);
        ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        IndexColorModel indexColorModel = colorModel instanceof IndexColorModel ? (IndexColorModel)colorModel : null;
        oSXOffScreenSurfaceData.initRaster(byteComponentRaster.getDataStorage(), byteComponentRaster.getDataOffset(n), byteComponentRaster.getWidth(), byteComponentRaster.getHeight(), byteComponentRaster.getPixelStride(), byteComponentRaster.getScanlineStride(), indexColorModel, n2, oSXOffScreenSurfaceData.fGraphicsStates, oSXOffScreenSurfaceData.fGraphicsStatesObject, oSXOffScreenSurfaceData.fImageInfo);
        oSXOffScreenSurfaceData.checkIfLazyPixelConversionDisabled();
        return oSXOffScreenSurfaceData;
    }

    public static SurfaceData createDataBC(BufferedImage bufferedImage, SurfaceType surfaceType, int n) {
        return OSXOffScreenSurfaceData.createDataBC(bufferedImage, surfaceType, n, bufferedImage.getType());
    }

    private static SurfaceData createDataBP(BufferedImage bufferedImage, SurfaceType surfaceType, int n) {
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = new OSXOffScreenSurfaceData(bufferedImage, surfaceType);
        BytePackedRaster bytePackedRaster = (BytePackedRaster)bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        IndexColorModel indexColorModel = colorModel instanceof IndexColorModel ? (IndexColorModel)colorModel : null;
        oSXOffScreenSurfaceData.initRaster(bytePackedRaster.getDataStorage(), bytePackedRaster.getDataBitOffset(), bytePackedRaster.getWidth(), bytePackedRaster.getHeight(), bytePackedRaster.getPixelBitStride(), bytePackedRaster.getScanlineStride() * 8, indexColorModel, n, oSXOffScreenSurfaceData.fGraphicsStates, oSXOffScreenSurfaceData.fGraphicsStatesObject, oSXOffScreenSurfaceData.fImageInfo);
        oSXOffScreenSurfaceData.checkIfLazyPixelConversionDisabled();
        return oSXOffScreenSurfaceData;
    }

    public static SurfaceData createDataBP(BufferedImage bufferedImage, SurfaceType surfaceType) {
        return OSXOffScreenSurfaceData.createDataBP(bufferedImage, surfaceType, bufferedImage.getType());
    }

    protected native void initRaster(Object var1, int var2, int var3, int var4, int var5, int var6, IndexColorModel var7, int var8, ByteBuffer var9, Object var10, ByteBuffer var11);

    protected native void initCustomRaster(IntBuffer var1, int var2, int var3, ByteBuffer var4, Object var5, ByteBuffer var6);

    public Object getLockObject() {
        return this.lock;
    }

    public OSXOffScreenSurfaceData(BufferedImage bufferedImage, SurfaceType surfaceType) {
        super(bufferedImage, surfaceType);
        this.fImageInfo.order(ByteOrder.nativeOrder());
        this.fImageInfoInt = this.fImageInfo.asIntBuffer();
        this.fImageInfoInt.put(0, 1);
        this.fImageInfoInt.put(1, 0);
        this.fImageInfoInt.put(2, 0);
        this.fImageInfoInt.put(3, 0);
        this.fImageInfoInt.put(4, 0);
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        Object object = this.getLockObject();
        synchronized (object) {
            int n7 = 0;
            int n8 = 0;
            if (sunGraphics2D.transformState == 2 || sunGraphics2D.transformState == 1) {
                n7 = (int)sunGraphics2D.transform.getTranslateX();
                n8 = (int)sunGraphics2D.transform.getTranslateY();
            } else if (sunGraphics2D.transformState != 0) {
                return false;
            }
            this.finishLazyDrawing();
            Shape shape = sunGraphics2D.getClip();
            sunGraphics2D.setClip(this.getBounds());
            Rectangle rectangle = this.clipCopyArea(sunGraphics2D, n, n2, n3, n4, n5, n6);
            if (rectangle == null) {
                return true;
            }
            n = rectangle.x - n7;
            n2 = rectangle.y - n8;
            n3 = rectangle.width;
            n4 = rectangle.height;
            sunGraphics2D.drawImage(this.bim, n + n5, n2 + n6, n + n5 + n3, n2 + n6 + n4, n + n7, n2 + n8, n + n3 + n7, n2 + n4 + n8, null);
            sunGraphics2D.setClip(shape);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, BufferedImage bufferedImage) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            if (bufferedImage == null) {
                bufferedImage = this.getDeviceConfiguration().createCompatibleImage(n3, n4);
            }
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.bim, 0, 0, n3, n4, n, n2, n + n3, n2 + n4, null);
            graphics2D.dispose();
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean xorSurfacePixels(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            int n6 = this.bim.getType();
            if (n6 == 3 || n6 == 2 || n6 == 1) {
                return this.xorSurfacePixels(OSXOffScreenSurfaceData.createData(bufferedImage), n5, n, n2, n3, n4);
            }
            return false;
        }
    }

    native boolean xorSurfacePixels(SurfaceData var1, int var2, int var3, int var4, int var5, int var6);

    public void clearRect(BufferedImage bufferedImage, int n, int n2) {
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = (OSXOffScreenSurfaceData)OSXOffScreenSurfaceData.createData(bufferedImage);
        if (!oSXOffScreenSurfaceData.clearSurfacePixels(n, n2)) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.dispose();
        }
    }

    native boolean clearSurfacePixels(int var1, int var2);

    public SurfaceData getCopyWithBgColor(Color color) {
        Object object;
        int n = this.bim.getWidth();
        int n2 = this.bim.getHeight();
        if (this.copyWithBgColor_cache == null || this.copyWithBgColor_cache.getWidth() < n || this.copyWithBgColor_cache.getHeight() < n2) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.copyWithBgColor_cache = ((GraphicsConfiguration)object).createCompatibleImage(n, n2);
        }
        object = this.copyWithBgColor_cache.createGraphics();
        ((Graphics)object).setColor(color);
        ((Graphics)object).fillRect(0, 0, n, n2);
        ((Graphics)object).drawImage(this.bim, 0, 0, n, n2, null);
        ((Graphics)object).dispose();
        return OSXOffScreenSurfaceData.getSurfaceData(this.copyWithBgColor_cache);
    }

    public void imageOnlyAccess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markImageConstant() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.fImageInfoInt.put(2, 1);
            this.fImageInfoInt.put(3, 1);
        }
    }

    public boolean isImageConstant() {
        return this.fImageInfoInt.get(3) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rasterRead(int n, int n2) {
        if (this.bim.getType() != 3) {
            this.rasterRead();
            return;
        }
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            if (this.fImageInfoInt.get(1) == 1) {
                this.syncXYToJavaPixel(n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rasterRead() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            if (this.fImageInfoInt.get(1) == 1) {
                this.syncToJavaPixels();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rasterWrite() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.finishLazyDrawing();
            this.fImageInfoInt.put(3, 0);
            if (this.fImageInfoInt.get(1) == 1) {
                this.syncToJavaPixels();
            }
            this.fImageInfoInt.put(0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rasterChanged() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.fImageInfoInt.put(3, 0);
            this.fImageInfoInt.put(0, 1);
            if (this.fImageInfoInt.get(1) == 1) {
                this.syncToJavaPixels();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rasterStolen() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.disableLazyDrawing();
            this.fImageInfoInt.put(2, 0);
            this.fImageInfoInt.put(3, 0);
            this.fImageInfoInt.put(4, 1);
            if (this.fImageInfoInt.get(1) == 1) {
                this.syncToJavaPixels();
            }
            if (this.bufImgSunRaster != null) {
                this.bufImgSunRaster.setRasterListener(null);
            }
        }
    }

    private native void syncToJavaPixels();

    private native void syncXYToJavaPixel(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFromCustom() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.bufImgSunRaster != null) {
                this.bufImgSunRaster.disableRasterListener();
            }
            int n = this.bim.getWidth();
            int n2 = this.bim.getHeight();
            this.bimBackup.setRGB(0, 0, n, n2, this.bim.getRGB(0, 0, n, n2, null, 0, n), 0, n);
            if (this.bufImgSunRaster != null) {
                this.bufImgSunRaster.enableRasterListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncToCustom() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.bufImgSunRaster != null) {
                this.bufImgSunRaster.disableRasterListener();
            }
            int n = this.bim.getWidth();
            int n2 = this.bim.getHeight();
            this.bim.setRGB(0, 0, n, n2, this.bimBackup.getRGB(0, 0, n, n2, null, 0, n), 0, n);
            if (this.bufImgSunRaster != null) {
                this.bufImgSunRaster.enableRasterListener();
            }
        }
    }

    void cacheRasters(BufferedImage bufferedImage) {
        this.bim = bufferedImage;
        this.bufImgRaster = bufferedImage.getRaster();
        if (this.bufImgRaster instanceof SunWritableRaster) {
            this.bufImgSunRaster = (SunWritableRaster)this.bufImgRaster;
        }
    }

    void setRasterListener() {
        if (this.bufImgSunRaster != null) {
            this.bufImgSunRaster.setRasterListener(this);
            Raster raster = this.bufImgSunRaster.getParent();
            if (raster != null) {
                if (raster instanceof SunWritableRaster) {
                    ((SunWritableRaster)raster).notifyStolen();
                }
                this.rasterStolen();
            }
        } else {
            this.rasterStolen();
        }
    }

    public static long makeNSImage(BufferedImage transparency) {
        Transparency transparency2;
        if (transparency.getType() != 3) {
            transparency2 = new BufferedImage(transparency.getWidth(), transparency.getHeight(), 3);
            Graphics2D graphics2D = ((BufferedImage)transparency2).createGraphics();
            graphics2D.drawImage((Image)((Object)transparency), 0, 0, null);
            transparency = transparency2;
        }
        transparency2 = OSXOffScreenSurfaceData.createNewSurface(transparency);
        return ((OSXOffScreenSurfaceData)transparency2)._makeNSImage();
    }

    native long _makeNSImage();

    void copyNSImagePixels(long l) {
        this._copyNSImagePixels(l);
        this.markImageConstant();
    }

    native void _copyNSImagePixels(long var1);

    void checkIfLazyPixelConversionDisabled() {
        if (!gUseLazyPixelConversion) {
            this.fImageInfoInt.put(4, 1);
        }
    }

    static {
        OSXOffScreenSurfaceData.initIDs();
        dcmBackup = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        IntArgbPreQ = SurfaceType.IntArgbPre.deriveSubType(DESC_INT_ARGB_PRE_Q);
        RuntimeOptions runtimeOptions = RuntimeOptions.getCurrentOptions();
        gUseLazyPixelConversion = RuntimeOptions.EnableLazyPixelConversion;
    }
}

