/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsConfig;
import apple.awt.CGraphicsDevice;
import apple.awt.CToolkit;
import apple.awt.ComponentModel;
import apple.awt.ContainerModel;
import apple.awt.RuntimeOptions;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.awt.peer.WindowPeer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class CWindow
extends ContainerModel
implements WindowPeer,
DialogPeer {
    private static final int kMinWindowWidth = 1;
    private static final int kMinWindowHeight = 1;
    private static final Dimension kMinSize = new Dimension(1, 1);
    static final int kCanFlushIndex = 0;
    static final int kIsDirtyIndex = 1;
    static final int kLastIndex = 2;
    public ComponentModel fClient;
    protected ByteBuffer fByteParameters;
    IntBuffer fIntParameters;
    private boolean fIsPopup = false;
    Object fFlushingLock = new PeerFlushingLock();
    static final long kMinFlushingPeriod = 1000 / RuntimeOptions.getCurrentOptions().LazyFlushingFPS;
    long lastTimeFlush = 0L;
    boolean isFlushingAllowed = true;
    int fFlushCountDepth = 0;

    public static CWindow create(Window window) {
        CWindow cWindow = new CWindow((Component)window);
        cWindow.initPeer();
        return cWindow;
    }

    CWindow(Component component) {
        super(component);
        this.fGraphicsConfiguration = this.getGraphicsConfiguration();
        ((CGraphicsDevice)this.fGraphicsConfiguration.getDevice()).addDisplayChangedListener(this);
        this.fClient = this;
    }

    protected void initPeer() {
        super.initPeer();
        this.fInsets = this._getInsets(this.fModelPtr);
    }

    protected void disposeImpl() {
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        cGraphicsDevice.removeDisplayChangedListener(this);
        if (this.isFullScreenWindow()) {
            cGraphicsDevice.fullScreenWindowDisposed(this);
        }
        this.destroyBuffers();
        super.disposeImpl();
    }

    private native long _getViewPtr(long var1);

    public boolean handlesWheelScrolling() {
        return false;
    }

    protected long initPeer(long l) {
        boolean bl;
        this.fIsPopup = this.fTarget.getName() == "###overrideRedirect###";
        long l2 = ((Window)this.fTarget).getOwner() != null ? ((CWindow)((Window)this.fTarget).getOwner().getPeer()).fModelPtr : 0L;
        this.initContainer();
        Rectangle rectangle = this.fTarget.getBounds();
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        boolean bl2 = this.fTarget instanceof Frame;
        boolean bl3 = this.fTarget instanceof Dialog;
        boolean bl4 = bl2 ? ((Frame)this.fTarget).isUndecorated() : (bl = bl3 ? ((Dialog)this.fTarget).isUndecorated() : true);
        boolean bl5 = bl2 ? ((Frame)this.fTarget).isResizable() : (bl3 ? ((Dialog)this.fTarget).isResizable() : false);
        boolean bl6 = false;
        if (bl3 || this.fIsPopup) {
            bl6 = true;
        }
        long l3 = this.createNativeWindow(l2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.fTarget.isEnabled(), this.fTarget.isVisible(), this.fTarget.getFont(), this.fTarget.getBackground(), this.fTarget.isBackgroundSet(), this.fTarget.getForeground(), this.fTarget.isForegroundSet(), bl6, this.getTitle(), bl2 ? ((Frame)this.fTarget).getExtendedState() : 0, cGraphicsDevice.getNSScreen(), bl3, bl, bl5, ((Window)this.fTarget).isFocusableWindow(), bl3 ? ((Dialog)this.fTarget).isModal() : false, ((Window)this.fTarget).isAlwaysOnTop(), this.fIsPopup, this.fByteParameters);
        return l3;
    }

    protected native long createNativeWindow(long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, Font var9, Color var10, boolean var11, Color var12, boolean var13, boolean var14, String var15, int var16, long var17, boolean var19, boolean var20, boolean var21, boolean var22, boolean var23, boolean var24, boolean var25, ByteBuffer var26);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(AWTEvent aWTEvent) {
        if (this.fIsPopup && aWTEvent.getID() == 102) {
            this.fTarget.repaint();
            try {
                this.getCWindowContainer().disableFlushing();
                this.paintArea.add(this.getBounds(), 801);
                this.paintArea.paint(this.fTarget, this.shouldClearRectBeforePaint());
            }
            finally {
                this.finishLazyDrawing();
                this.getCWindowContainer().enableFlushing();
            }
        } else {
            super.handleEvent(aWTEvent);
        }
    }

    protected boolean getResizable() {
        return false;
    }

    protected Color getBackgroundColor() {
        return SystemColor.window;
    }

    protected String getTitle() {
        return null;
    }

    void initContainer() {
        super.initContainer();
        if (!this.fTarget.isForegroundSet()) {
            this.fTarget.setForeground(Color.black);
        }
        if (!this.fTarget.isBackgroundSet()) {
            this.fTarget.setBackground(this.getBackgroundColor());
        }
        if (this.fTarget.getFont() == null) {
            this.fTarget.setFont(sDefaultFont);
        }
        this.fByteParameters = ByteBuffer.allocateDirect(8);
        this.fByteParameters.order(ByteOrder.nativeOrder());
        this.fIntParameters = this.fByteParameters.asIntBuffer();
    }

    public void mouseWheel(int n) {
    }

    public void toFront() {
        this.toFront(this.fModelPtr, ((Window)this.fTarget).isFocusableWindow());
    }

    private native void toFront(long var1, boolean var3);

    public void toBack() {
        this.toBack(this.fModelPtr);
    }

    private native void toBack(long var1);

    public void updateAlwaysOnTop() {
        this.setAlwaysOnTop(this.fModelPtr, ((Window)this.fTarget).isAlwaysOnTop());
    }

    native void setAlwaysOnTop(long var1, boolean var3);

    public boolean requestWindowFocus() {
        return false;
    }

    public boolean isFullScreenWindow() {
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        Window window = cGraphicsDevice.getFullScreenWindow();
        return window == this.fTarget;
    }

    public void setTitle(String string) {
        this._setTitle(this.fModelPtr, string);
    }

    private native void _setTitle(long var1, String var3);

    public void setResizable(boolean bl) {
        this._setResizable(this.fModelPtr, bl);
    }

    private native void _setResizable(long var1, boolean var3);

    public void setState(int n) {
        this._setState(this.fModelPtr, n);
    }

    private native void _setState(long var1, int var3);

    public int getState() {
        return this._getState(this.fModelPtr);
    }

    private native int _getState(long var1);

    public void setMaximizedBounds(Rectangle rectangle) {
        if (rectangle == null) {
            this._resetMaxBounds(this.fModelPtr);
        } else {
            this._setMaximizeBounds(this.fModelPtr, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private native void _resetMaxBounds(long var1);

    private native void _setMaximizeBounds(long var1, int var3, int var4, int var5, int var6);

    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 3);
    }

    private native Insets _getInsets(long var1);

    public void setVisible(boolean bl) {
        this._setVisible(this.fModelPtr, bl, ((Window)this.fTarget).isFocusableWindow(), false, ((Window)this.fTarget).isAlwaysOnTop());
    }

    native void _setVisible(long var1, boolean var3, boolean var4, boolean var5, boolean var6);

    void dynamicallyLayoutContainer() {
        final Container container = (Container)this.fTarget;
        try {
            CToolkit.invokeAndWait(new Runnable(){

                public void run() {
                    container.invalidate();
                    container.validate();
                }
            }, container);
            CToolkit.invokeAndWait(new Runnable(){

                public void run() {
                }
            }, container);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Point getLocationOnScreen() {
        if (this.fModelPtr == 0L) {
            return null;
        }
        return this._getLocationOnScreen(this.fModelPtr);
    }

    private native Point _getLocationOnScreen(long var1);

    public void requestFocus() {
        CToolkit.notImplemented();
    }

    public boolean isFocusTraversable() {
        CToolkit.notImplemented();
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public Dimension getMinimumSize() {
        return kMinSize;
    }

    CWindow getCWindowContainer() {
        return this;
    }

    void windowUpdate() {
    }

    private native void resetGraphicsConfiguration(long var1, Component var3);

    public void setAlpha(float f) {
        this._setAlpha(this.fModelPtr, f);
    }

    private native void _setAlpha(long var1, float var3);

    public void setDocumentEdited(boolean bl) {
        this._setDocumentEdited(this.fModelPtr, bl);
    }

    private native void _setDocumentEdited(long var1, boolean var3);

    public void displayChanged() {
        int n = this.getScreenIndex(this.fModelPtr);
        if (n < 0) {
            return;
        }
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        CGraphicsDevice cGraphicsDevice2 = (CGraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[n];
        this.fGraphicsConfiguration = (CGraphicsConfig)cGraphicsDevice2.getDefaultConfiguration();
        this.resetGraphicsConfiguration(this.fModelPtr, this.fTarget);
        if (cGraphicsDevice != cGraphicsDevice2) {
            cGraphicsDevice.removeDisplayChangedListener(this);
            cGraphicsDevice2.addDisplayChangedListener(this);
        }
        super.displayChanged();
    }

    private native int getScreenIndex(long var1);

    native void _flush(long var1);

    native void _flushGL();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFlushingAllowed() {
        Object object = this.fFlushingLock;
        synchronized (object) {
            if (this.isFlushingAllowed) {
                this.fClient.finishLazyDrawing();
            }
            return this.isFlushingAllowed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableFlushing() {
        Object object = this.fFlushingLock;
        synchronized (object) {
            if (this.fFlushCountDepth == 0) {
                this.fIntParameters.put(0, 0);
                this.isFlushingAllowed = false;
            }
            --this.fFlushCountDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableFlushing() {
        Object object = this.fFlushingLock;
        synchronized (object) {
            ++this.fFlushCountDepth;
            if (this.fFlushCountDepth == 0) {
                long l = System.currentTimeMillis();
                if (l - this.lastTimeFlush > kMinFlushingPeriod) {
                    this.lastTimeFlush = l;
                    this.fClient.finishLazyDrawing();
                    this.fIntParameters.put(0, 1);
                    this.isFlushingAllowed = true;
                    switch (fRenderer) {
                        case 1: 
                        case 2: {
                            this._flush(this.fModelPtr);
                            break;
                        }
                        case 3: {
                            this._flushGL();
                            break;
                        }
                    }
                } else {
                    this.fIntParameters.put(0, 1);
                    this.isFlushingAllowed = true;
                }
            }
        }
    }

    public void markDirty(boolean bl) {
        this.fIntParameters.put(1, bl ? 1 : 0);
    }

    native long _getCGWindowRef(long var1);

    public long getData() {
        return this._getCGWindowRef(this.fModelPtr);
    }

    class PeerFlushingLock {
        PeerFlushingLock() {
        }
    }
}

