/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsDevice;
import apple.awt.OSXVolatileImage;
import apple.awt.RuntimeOptions;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import sun.awt.image.OffScreenImage;
import sun.security.action.LoadLibraryAction;

public class CGraphicsConfig
extends GraphicsConfiguration {
    private String cachedStringID = null;
    static ColorModel sDefaultColorModelWithAlphaPre;
    static ColorModel sDefaultColorModelWithAlpha;
    static ColorModel sDefaultColorModelNoAlpha;
    static final int Renderer;
    BufferCapabilities bufferCaps;
    ImageCapabilities imageCaps;
    CGraphicsDevice device;

    public CGraphicsConfig(CGraphicsDevice cGraphicsDevice) {
        this.device = cGraphicsDevice;
    }

    public GraphicsDevice getDevice() {
        return this.device;
    }

    public String getIDString() {
        if (this.cachedStringID == null) {
            this.cachedStringID = this._getIDString();
        }
        return this.cachedStringID;
    }

    native String _getIDString();

    public VolatileImage createCompatibleVolatileImage(int n, int n2) {
        if (Renderer == 1) {
            return this.createCompatibleVolatileImage(n, n2, 3);
        }
        return this.createCompatibleVolatileImage(n, n2, 1);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, int n3) {
        return new OSXVolatileImage(this, n, n2, n3);
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        if (Renderer == 1) {
            return this.createCompatibleImage(n, n2, 3);
        }
        return this.createCompatibleImage(n, n2, 1);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return new BufferedImage(n, n2, 1);
            }
            case 2: 
            case 3: {
                if (Renderer == 1) {
                    return new BufferedImage(n, n2, 3);
                }
                return new BufferedImage(n, n2, 2);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n3);
    }

    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = null;
        colorModel = Renderer == 1 ? this.getColorModel(3) : this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new OffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    public ColorModel getColorModel() {
        if (Renderer == 1) {
            return this.getColorModel(3);
        }
        return this.getColorModel(1);
    }

    public ColorModel getColorModel(int n) {
        if (n == 1) {
            return sDefaultColorModelNoAlpha;
        }
        if (n == 3) {
            if (Renderer == 1) {
                return sDefaultColorModelWithAlphaPre;
            }
            return sDefaultColorModelWithAlpha;
        }
        if (n == 2) {
            if (Renderer == 1) {
                return sDefaultColorModelWithAlphaPre;
            }
            return sDefaultColorModelWithAlpha;
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    private native Rectangle getBoundsForDisplay();

    public Rectangle getBounds() {
        return this.getBoundsForDisplay();
    }

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new BufferCapabilities(this.getImageCapabilities(), this.getImageCapabilities(), BufferCapabilities.FlipContents.PRIOR){

                public boolean isMultiBufferAvailable() {
                    return true;
                }

                public boolean isFullScreenRequired() {
                    return false;
                }

                public boolean isPageFlipping() {
                    return true;
                }
            };
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        if (this.imageCaps == null) {
            this.imageCaps = new ImageCapabilities(false);
        }
        return this.imageCaps;
    }

    static {
        Renderer = RuntimeOptions.getCurrentOptions().Renderer;
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        sDefaultColorModelWithAlphaPre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        sDefaultColorModelWithAlpha = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        sDefaultColorModelNoAlpha = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    }
}

