/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CDropTarget;
import apple.awt.CGraphicsConfig;
import apple.awt.CToolkit;
import apple.awt.CWindow;
import apple.awt.PeerImpl;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import sun.awt.DisplayChangedListener;

public abstract class CComponent
extends PeerImpl
implements ComponentPeer,
DropTargetPeer,
DisplayChangedListener {
    CWindow fContainingWindow = null;
    private int fNumDropTargets = 0;
    private CDropTarget fDropTarget = null;

    CWindow getCWindowContainer() {
        if (this.fContainingWindow == null) {
            Container container;
            for (container = this.fTarget.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
            this.fContainingWindow = (CWindow)container.getPeer();
        }
        return this.fContainingWindow;
    }

    public final boolean isObscured() {
        return false;
    }

    public final boolean canDetermineObscurity() {
        return false;
    }

    public final boolean requestFocus(Component component, boolean bl, boolean bl2, long l) {
        if (this.processSynchronousLightweightTransfer(this.fTarget, component, bl, bl2, l)) {
            return true;
        }
        return this._requestFocus(component, bl, bl2, l);
    }

    private native boolean _requestFocus(Component var1, boolean var2, boolean var3, long var4);

    private native boolean processSynchronousLightweightTransfer(Component var1, Component var2, boolean var3, boolean var4, long var5);

    public abstract boolean isFocusable();

    public abstract boolean handlesWheelScrolling();

    public void paint(Graphics graphics) {
        this.fTarget.paint(graphics);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void print(Graphics graphics) {
        this.fTarget.paint(graphics);
    }

    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    public void reparent(ContainerPeer containerPeer) {
    }

    public boolean isReparentSupported() {
        return false;
    }

    public void layout() {
    }

    public Rectangle getBounds() {
        return this.fTarget.getBounds();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.fTarget.getSize();
    }

    public final ColorModel getColorModel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel();
        }
        return null;
    }

    public final Toolkit getToolkit() {
        return CToolkit.sToolkit;
    }

    public Graphics getGraphics() {
        CToolkit.notImplemented();
        return null;
    }

    public final FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public abstract void setForeground(Color var1);

    public abstract void setBackground(Color var1);

    public abstract void setFont(Font var1);

    public final Image createImage(ImageProducer imageProducer) {
        return this.getToolkit().createImage(imageProducer);
    }

    public final Image createImage(int n, int n2) {
        CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
        return cGraphicsConfig.createAcceleratedImage(this.fTarget, n, n2);
    }

    public final boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public final int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public final Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public final Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public final void show() {
        this.setVisible(true);
    }

    public final void hide() {
        this.setVisible(false);
    }

    public final void enable() {
        this.setEnabled(true);
    }

    public final void disable() {
        this.setEnabled(false);
    }

    public final void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 3);
    }

    final void postEvent(AWTEvent aWTEvent) {
        CToolkit.postEvent(CToolkit.targetToAppContext(this.fTarget), aWTEvent);
    }

    public synchronized void addDropTarget(DropTarget dropTarget) {
        if (++this.fNumDropTargets == 1) {
            if (this.fDropTarget != null) {
                System.err.println("CComponent.addDropTarget(): current drop target is non-null.");
            }
            this.fDropTarget = CDropTarget.createDropTarget(dropTarget, this.fTarget, this);
        }
    }

    public synchronized void removeDropTarget(DropTarget dropTarget) {
        if (--this.fNumDropTargets == 0) {
            if (this.fDropTarget != null) {
                this.fDropTarget.dispose();
                this.fDropTarget = null;
            } else {
                System.err.println("CComponent.removeDropTarget(): current drop target is null.");
            }
        }
    }

    public synchronized void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
    }

    public synchronized void destroyBuffers() {
    }

    public Image getFrontBuffer() {
        return null;
    }

    public Image getBackBuffer() {
        return null;
    }

    public synchronized void flip(BufferCapabilities.FlipContents flipContents) {
    }

    public void displayChanged() {
    }

    public void paletteChanged() {
    }
}

