/*
 * Decompiled with CFR 0.152.
 */
package org.swixml.layoutconverters;

import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import org.swixml.Attribute;
import org.swixml.LayoutConverter;
import org.swixml.SwingEngine;
import org.swixml.converters.Util;
import org.w3c.dom.Element;

public class GridBagLayoutConverter
implements LayoutConverter {
    @Override
    public String getID() {
        return "gridbaglayout";
    }

    @Override
    public LayoutManager convertLayoutAttribute(Attribute attribute) {
        GridBagLayout gridBagLayout;
        block13: {
            StringTokenizer stringTokenizer = new StringTokenizer(attribute.getValue(), "(,)");
            stringTokenizer.nextToken();
            gridBagLayout = new GridBagLayout();
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    String string = stringTokenizer.nextToken();
                    Field field = GridBagLayout.class.getField(string);
                    if (field != null) {
                        Class<?> clazz = field.getType();
                        if (int[].class.equals(clazz)) {
                            field.set(gridBagLayout, Util.ia(stringTokenizer));
                        } else if (double[].class.equals(clazz)) {
                            field.set(gridBagLayout, Util.da(stringTokenizer));
                        }
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (SwingEngine.DEBUG_MODE) {
                        System.err.println(noSuchFieldException.getMessage());
                    }
                }
                catch (SecurityException securityException) {
                    if (SwingEngine.DEBUG_MODE) {
                        System.err.println(securityException.getMessage());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (SwingEngine.DEBUG_MODE) {
                        System.err.println(illegalArgumentException.getMessage());
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!SwingEngine.DEBUG_MODE) break block13;
                    System.err.println(illegalAccessException.getMessage());
                }
            }
        }
        return gridBagLayout;
    }

    @Override
    public LayoutManager convertLayoutElement(Element element) {
        String string = Attribute.getAttributeValue(element, "columnWidths");
        String string2 = Attribute.getAttributeValue(element, "rowHeights");
        String string3 = Attribute.getAttributeValue(element, "columnWeights");
        String string4 = Attribute.getAttributeValue(element, "rowWeights");
        GridBagLayout gridBagLayout = new GridBagLayout();
        if (string != null) {
            gridBagLayout.columnWidths = Util.ia(new StringTokenizer(string, ","));
        }
        if (string2 != null) {
            gridBagLayout.rowHeights = Util.ia(new StringTokenizer(string2, ","));
        }
        if (string3 != null) {
            gridBagLayout.columnWeights = Util.da(new StringTokenizer(string3, ","));
        }
        if (string4 != null) {
            gridBagLayout.rowWeights = Util.da(new StringTokenizer(string4, ","));
        }
        return gridBagLayout;
    }

    @Override
    public Object convertConstraintsAttribute(Attribute attribute) {
        return null;
    }

    @Override
    public Object convertConstraintsElement(Element element) {
        return null;
    }
}

